% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{anova.ocm}
\alias{anova.ocm}
\title{Anova method for Continuous Ordinal Fits}
\usage{
\method{anova}{ocm}(object, ...)
}
\arguments{
\item{object}{an object of class \code{ocm}}

\item{...}{one or more additional \code{ocm} objects}
}
\value{
The method returns an object of class \code{anova.ocm} and \code{data.frame}, reporting for each model, in hierarchical order:
\item{no.par}{number of parameters}
\item{AIC}{Akaike information criterion}
\item{loglik}{log-likelihood}
\item{LR.stat}{likelihood ratio statistic}
\item{df}{difference in the degrees of freedom in the models being compared}
\item{Pr(>Chisq)}{p-value from the likelihood ratio test}
}
\description{
Comparison of continuous ordinal models using likelihood ratio tests.
}
\details{
Likelihood ratio testing of nested models is performed.
}
\examples{
\dontrun{
fit.overall  <- ocm(overall  ~ cycleno + bsa + treatment, data=ANZ0001.sub, scale=c(0,100))
anova(fit.overall, update(fit.overall, .~. + age))
}
}
\author{
Maurizio Manuguerra, Gillian Heller
 @seealso \code{\link{ocm}}, \code{\link{print.anova.ocm}}
}
\concept{anova}
