#' Generates counts from table frequencies for 4 category items
#'
#' @param mij Matrix of counts.
#' @returns a list containing
#'    wm1m1:  for -1, -1
#'    wm10:   for -1, 0
#'    wm11:   for -1, 1
#'    w00:    for 0, 0
#'    w01:    for 0, 1
#'    w11:    for 1, 1
Cliff_counts_4 <- function(mij) {

  wm1m1 <- (mij[2,1] * mij[2,1] + mij[2,1] * mij[3,1] + mij[2,1] * mij[4,1] + mij[2,2] * mij[3,1]
            + mij[2,2] * mij[4,1] + mij[2,3] * mij[4,1] + mij[3,1] * mij[2,1] + mij[3,1] * mij[2,2]
            + mij[3,1] * mij[3,1] + mij[3,1] * mij[3,2] + mij[3,1] * mij[4,1] + mij[3,1] * mij[4,2]
            + mij[3,2] * mij[3,1] + mij[3,2] * mij[3,2] + mij[3,2] * mij[4,1] + mij[3,2] * mij[4,2]
            + mij[3,3] * mij[4,1] + mij[3,3] * mij[4,2] + mij[4,1] * mij[2,1] + mij[4,1] * mij[2,2]
            + mij[4,1] * mij[2,3] + mij[4,1] * mij[3,1] + mij[4,1] * mij[3,2] + mij[4,1] * mij[3,3]
            + mij[4,1] * mij[4,1] + mij[4,1] * mij[4,2] + mij[4,1] * mij[4,3] + mij[4,2] * mij[3,1]
            + mij[4,2] * mij[3,2] + mij[4,2] * mij[3,3] + mij[4,2] * mij[4,1] + mij[4,2] * mij[4,2]
            + mij[4,2] * mij[4,3] + mij[4,3] * mij[4,1] + mij[4,3] * mij[4,2] + mij[4,3] * mij[4,3] )

  wm10 <- (mij[1,1] * mij[2,1] + mij[1,1] * mij[3,1] + mij[1,1] * mij[4,1] + mij[1,2] * mij[3,1]
           + mij[1,2] * mij[4,1] + mij[1,3] * mij[4,1] + mij[2,1] * mij[1,1] + mij[2,1] * mij[2,2]
           + mij[2,1] * mij[3,2] + mij[2,1] * mij[4,2] + mij[2,2] * mij[2,1] + mij[2,2] * mij[3,2]
           + mij[2,2] * mij[4,2] + mij[2,3] * mij[3,1] + mij[2,3] * mij[4,2] + mij[2,4] * mij[4,1]
           + mij[3,1] * mij[1,1] + mij[3,1] * mij[1,2] + mij[3,1] * mij[2,3] + mij[3,1] * mij[3,3]
           + mij[3,1] * mij[4,3] + mij[3,2] * mij[2,1] + mij[3,2] * mij[2,2] + mij[3,2] * mij[3,3]
           + mij[3,2] * mij[4,3] + mij[3,3] * mij[3,1] + mij[3,3] * mij[3,2] + mij[3,3] * mij[4,3]
           + mij[3,4] * mij[4,1] + mij[3,4] * mij[4,2] + mij[4,1] * mij[1,1] + mij[4,1] * mij[1,2]
           + mij[4,1] * mij[1,3] + mij[4,1] * mij[2,4] + mij[4,1] * mij[3,4] + mij[4,1] * mij[4,4]
           + mij[4,2] * mij[2,1] + mij[4,2] * mij[2,2] + mij[4,2] * mij[2,3] + mij[4,2] * mij[3,4]
           + mij[4,2] * mij[4,4] + mij[4,3] * mij[3,1] + mij[4,3] * mij[3,2] + mij[4,3] * mij[3,3]
           + mij[4,3] * mij[4,4] + mij[4,4] * mij[4,1] + mij[4,4] * mij[4,2] + mij[4,4] * mij[4,3] )

  wm11 <- (mij[1,1] * mij[2,2] + mij[1,1] * mij[2,3] + mij[1,1] * mij[2,4] + mij[1,1] * mij[3,2]
           + mij[1,1] * mij[3,3] + mij[1,1] * mij[3,4] + mij[1,1] * mij[4,2] + mij[1,1] * mij[4,3]
           + mij[1,1] * mij[4,4] + mij[1,2] * mij[3,2] + mij[1,2] * mij[3,3] + mij[1,2] * mij[3,4]
           + mij[1,2] * mij[4,2] + mij[1,2] * mij[4,3] + mij[1,2] * mij[4,4] + mij[1,3] * mij[4,2]
           + mij[1,3] * mij[4,3] + mij[1,3] * mij[4,4] + mij[2,1] * mij[2,3] + mij[2,1] * mij[2,4]
           + mij[2,1] * mij[3,3] + mij[2,1] * mij[3,4] + mij[2,1] * mij[4,3] + mij[2,1] * mij[4,4]
           + mij[2,2] * mij[1,1] + mij[2,2] * mij[3,3] + mij[2,2] * mij[3,4] + mij[2,2] * mij[4,3]
           + mij[2,2] * mij[4,4] + mij[2,3] * mij[1,1] + mij[2,3] * mij[2,1] + mij[2,3] * mij[4,3]
           + mij[2,3] * mij[4,4] + mij[2,4] * mij[1,1] + mij[2,4] * mij[2,1] + mij[2,4] * mij[3,1]
           + mij[3,1] * mij[2,4] + mij[3,1] * mij[3,4] + mij[3,1] * mij[4,4] + mij[3,2] * mij[1,1]
           + mij[3,2] * mij[1,2] + mij[3,2] * mij[3,4] + mij[3,2] * mij[4,4] + mij[3,3] * mij[1,1]
           + mij[3,3] * mij[1,2] + mij[3,3] * mij[2,1] + mij[3,3] * mij[2,2] + mij[3,3] * mij[4,4]
           + mij[3,4] * mij[1,1] + mij[3,4] * mij[1,2] + mij[3,4] * mij[2,1] + mij[3,4] * mij[2,2]
           + mij[3,4] * mij[3,1] + mij[3,4] * mij[3,2] + mij[4,2] * mij[1,1] + mij[4,2] * mij[1,2]
           + mij[4,2] * mij[1,3] + mij[4,3] * mij[1,1] + mij[4,3] * mij[1,2] + mij[4,3] * mij[1,3]
           + mij[4,3] * mij[2,1] + mij[4,3] * mij[2,2] + mij[4,3] * mij[2,3] + mij[4,4] * mij[1,1]
           + mij[4,4] * mij[1,2] + mij[4,4] * mij[1,3] + mij[4,4] * mij[2,1] + mij[4,4] * mij[2,2]
           + mij[4,4] * mij[2,3] + mij[4,4] * mij[3,1] + mij[4,4] * mij[3,2] + mij[4,4] * mij[3,3] )

  w00 <- (mij[1,1] * mij[1,1] + mij[1,2] * mij[2,1] + mij[1,3] * mij[3,1] + mij[1,4] * mij[4,1]
          + mij[2,1] * mij[1,2] + mij[2,2] * mij[2,2] + mij[2,3] * mij[3,2] + mij[2,4] * mij[4,2]
          + mij[3,1] * mij[1,3] + mij[3,2] * mij[2,3] + mij[3,3] * mij[3,3] + mij[3,4] * mij[4,3]
          + mij[4,1] * mij[1,4] + mij[4,2] * mij[2,4] + mij[4,3] * mij[3,4] + mij[4,4] * mij[4,4] )

  w01 <- (mij[1,1] * mij[1,2] + mij[1,1] * mij[1,3] + mij[1,1] * mij[1,4] + mij[1,2] * mij[1,1]
          + mij[1,2] * mij[2,2] + mij[1,2] * mij[2,3] + mij[1,2] * mij[2,4] + mij[1,3] * mij[1,1]
          + mij[1,3] * mij[2,1] + mij[1,3] * mij[3,2] + mij[1,3] * mij[3,3] + mij[1,3] * mij[3,4]
          + mij[1,4] * mij[1,1] + mij[1,4] * mij[2,1] + mij[1,4] * mij[3,1] + mij[1,4] * mij[4,2]
          + mij[1,4] * mij[4,3] + mij[1,4] * mij[4,4] + mij[2,1] * mij[1,3] + mij[2,1] * mij[1,4]
          + mij[2,2] * mij[1,2] + mij[2,2] * mij[2,3] + mij[2,2] * mij[2,4] + mij[2,3] * mij[1,2]
          + mij[2,3] * mij[2,2] + mij[2,3] * mij[3,3] + mij[2,3] * mij[3,4] + mij[2,4] * mij[1,2]
          + mij[2,4] * mij[2,2] + mij[2,4] * mij[3,2] + mij[2,4] * mij[4,3] + mij[2,4] * mij[4,4]
          + mij[3,1] * mij[1,4] + mij[3,2] * mij[1,3] + mij[3,2] * mij[2,4] + mij[3,3] * mij[1,3]
          + mij[3,3] * mij[2,3] + mij[3,3] * mij[3,4] + mij[3,4] * mij[1,3] + mij[3,4] * mij[2,3]
          + mij[3,4] * mij[3,3] + mij[3,4] * mij[4,4] + mij[4,2] * mij[1,4] + mij[4,3] * mij[1,4]
          + mij[4,3] * mij[2,4] + mij[4,4] * mij[1,4] + mij[4,4] * mij[2,4] + mij[4,4] * mij[3,4] )

  w11 <- (mij[1,2] * mij[1,2] + mij[1,2] * mij[1,3] + mij[1,2] * mij[1,4] + mij[1,3] * mij[1,2]
          + mij[1,3] * mij[1,3] + mij[1,3] * mij[1,4] + mij[1,3] * mij[2,2] + mij[1,3] * mij[2,3]
          + mij[1,3] * mij[2,4] + mij[1,4] * mij[1,2] + mij[1,4] * mij[1,3] + mij[1,4] * mij[1,4]
          + mij[1,4] * mij[2,2] + mij[1,4] * mij[2,3] + mij[1,4] * mij[2,4] + mij[1,4] * mij[3,2]
          + mij[1,4] * mij[3,3] + mij[1,4] * mij[3,4] + mij[2,2] * mij[1,3] + mij[2,2] * mij[1,4]
          + mij[2,3] * mij[1,3] + mij[2,3] * mij[1,4] + mij[2,3] * mij[2,3] + mij[2,3] * mij[2,4]
          + mij[2,4] * mij[1,3] + mij[2,4] * mij[1,4] + mij[2,4] * mij[2,3] + mij[2,4] * mij[2,4]
          + mij[2,4] * mij[3,3] + mij[2,4] * mij[3,4] + mij[3,2] * mij[1,4] + mij[3,3] * mij[1,4]
          + mij[3,3] * mij[2,4] + mij[3,4] * mij[1,4] + mij[3,4] * mij[2,4] + mij[3,4] * mij[3,4] )

  result <- list("wm1m1" = wm1m1, "wm10" = wm10, "wm11" = wm11,
                 "w00" = w00, w01 = w01, "w11" = w11)
  result
}
