test_that("Goodman_diagonals_parameter_symmetry", {
  n <- vision_data
  r <- nrow(n)

  result <- Goodman_diagonals_parameter_symmetry(n)
  chisq <- result$individual_chisq
  expect_true(abs(0.22 - chisq[1]) <= 0.005)
  expect_true(abs(0.28 - chisq[2]) <= 0.005)

  df <- result$individual_df
  expect_equal(2, df[1])
  expect_equal(1, df[2])

  expect_true(abs(0.50 - result$omnibus_chisq) <= 0.005)
  expect_equal(3, result$omnibus_df)

  expect_true(abs(6.76 - result$equality_chisq) <= 0.005)

  expect_equal(r - 2, result$equality_df)

  delta <- result$delta
  expect_true(abs(0.86 - delta[1]) <= 0.005)
  expect_true(abs(0.99 - delta[2]) <= 0.005)
  expect_true(abs(0.55 - delta[3]) <= 0.005)
}
)


test_that("Goodman_constrained_diagonals_parameter_symmetry", {
  n <- vision_data
  r <- nrow(n)
  equality <- c(TRUE, TRUE, FALSE)

  result <- Goodman_constrained_diagonals_parameter_symmetry(n, equality)

  expect_true(abs(2.03 - result$pooled_chisq) <= 0.007,
              info=paste(2.03, result$pooled_chisq))
  expect_equal(4, as.numeric(result$pooled_df),
              info=paste(4, result$pooled_df))

  expect_true(abs(2.03 - result$omnibus_chisq) <= 0.007,
              info=paste(2.03, result$omnibus_chisq))
  expect_equal(4, as.numeric(result$omnibus_df))

  delta <- result$delta
  expect_true(abs(0.55 - delta[1]) <= 0.005)
  expect_true(abs(0.88 - delta[2]) <= 0.005)
  expect_true(abs(0.88 - result$delta_pooled) <= 0.005)

  expect_true(abs(2.03 - result$pooled_chisq) <= 0.007,
              info=paste(2.03, result$pooled_chisq))
  expect_equal(4, as.numeric(result$pooled_df),
              info=paste(4, result$pooled_df))

  expect_true(abs(5.22 - result$equality_chisq) <= 0.005)
}
)


test_that("Goodman_fixed_parameter", {
  verbose=FALSE
  n <- vision_data
  r <- nrow(n)
  delta <- rep(1.0, r - 1)
  phi <- matrix(0.1, nrow=r, ncol=r)
  for (i in 1:r) {
    phi[i, i] <- 1.0
  }

  fixed <- c(FALSE, TRUE, FALSE)

  result <- Goodman_fixed_parameter(n, delta, fixed, verbose = verbose)
  delta <- result$delta
  expect_true(abs(0.86 - delta[1]) <= 0.005)
  expect_true(abs(1.00 - delta[2]) <= 0.005)
  expect_true(abs(0.55 - delta[3]) <= 0.005)

  expect_true(abs(0.52 - result$chisq) <= 0.005)
  expect_equal(4, result$df)
}
)
