% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names_api.R
\name{query_names}
\alias{query_names}
\title{Query the OS Names API}
\usage{
query_names(
  x,
  limit = 100,
  bounds,
  bbox_filter,
  local_type,
  key = get_os_key(),
  returnType = c("geojson", "list", "sf"),
  ...
)
}
\arguments{
\item{x}{The free text search parameter.}

\item{limit}{(numeric) The maximum number of features to return.
Default is 100.}

\item{bounds}{Biases the search results to a certain area. Should be of type
\code{qExtent} created by the \code{extent_from_*} functions with CRS =
EPSG:27700.}

\item{bbox_filter}{Filters the results to a certain area. Should be of type
\code{qExtent} created by the \code{extent_from_*} functions with CRS =
EPSG:27700.}

\item{local_type}{(character) Filters the results to certain local types. The
available local types can be found at:
\url{https://osdatahub.os.uk/docs/names/technicalSpecification}.}

\item{key}{(character) OS API key. Default action is to search for an
environment variable using \code{get_os_key()}.}

\item{returnType}{(character) Return the query results as the raw
\code{'geojson'}, a nested \code{'list'} object containing the returns,
or convert them into Simple Features and return an object of class
\code{'sf'}.}

\item{...}{Additional parameters (not currently used).}
}
\value{
A GeoJSON string with the results of the API query, a list object,
or an object of class \code{sf} based on the \code{returnType} parameter.
}
\description{
Retrieve information from a geographic directory of identifiable places based
on a free text search.
}
\details{
The OS Names API is a geographic directory containing basic
information about identifiable places. Those places are divided into
themes, but the name of the place is the key property used in queries.
The free text search is intended to be a "fuzzy" search.

Within OS Names, place names aren’t unique. Extra location details are
provided to help users refine their queries and accurately identify the
named place they’re interested in. These details include postcode district,
populated place, district/borough, county/unitary authority, European
region and country. Queries can also be refined by supplying bounding boxes
or local types to search.

Technical details on the Names API are documented on the Data Hub:
\url{https://osdatahub.os.uk/docs/names/technicalSpecification}.
}
\examples{
\dontshow{if (has_os_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Find names places by text search.
results <- query_names('Buckingham Palace', limit = 5)

# Use filters
results <- query_names('Southampton', local_type = 'City')

# Limit results to a bounding box
extent <- extent_from_bbox(c(600000, 310200, 600900, 310900),
                           crs = 'EPSG:27700')

results <- query_names('Norwich', bbox_filter = extent)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=query_nearest_names]{query_nearest_names()}}, \link{extent}
}
