% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim-osmdata.R
\name{trim_osmdata}
\alias{trim_osmdata}
\title{trim_osmdata}
\usage{
trim_osmdata(dat, bb_poly, exclude = TRUE)
}
\arguments{
\item{dat}{An \code{osmdata} object returned from \code{\link[=osmdata_sf]{osmdata_sf()}} or
\code{\link[=osmdata_sc]{osmdata_sc()}}.}

\item{bb_poly}{An \code{sf} or \code{sfc} object, or matrix representing a bounding
polygon. Can be obtained with \code{getbb (..., format_out = "polygon")} or
\code{getbb (..., format_out = "sf_polygon")} (and possibly
selected from resultant list where multiple polygons are returned).}

\item{exclude}{If \code{TRUE}, objects are trimmed exclusively, only retaining those
strictly within the bounding polygon; otherwise all objects which partly
extend within the bounding polygon are retained.}
}
\value{
A trimmed version of \code{dat}, reduced only to those components
lying within the bounding polygon.
}
\description{
Trim an \code{osmdata} object to within a bounding polygon
}
\note{
It will generally be necessary to pre-load the \pkg{sf} package for
this function to work correctly.

Caution is advised when using polygons obtained from Nominatim via
\code{getbb(..., format_out = "polygon"|"sf_polygon")}. These shapes can be
outdated and thus could cause the trimming operation to not give results
expected based on the current state of the OSM data.

To reduce the downloaded data from Overpass, you can do the trimming in
the server-side using \code{getbb(..., format_out = "osm_type_id")}
(see examples).
}
\examples{
\dontrun{
bb <- getbb ("colchester uk")
query <- opq (bb) |>
    add_osm_feature (key = "highway")
# Then extract data from 'Overpass' API
dat <- osmdata_sf (query, quiet = FALSE)
# Then get bounding *polygon* for Colchester, as opposed to rectangular
# bounding box, and use that to trim data within that polygon:
bb_pol <- getbb ("colchester uk", format_out = "polygon")
library (sf) # required for this function to work
dat_tr <- trim_osmdata (dat, bb_pol)
bb_sf <- getbb ("colchester uk", format_out = "sf_polygon")
class (bb_sf) # sf data.frame
dat_tr <- trim_osmdata (dat, bb_sf)
bb_sp <- as (bb_sf, "Spatial")
class (bb_sp) # SpatialPolygonsDataFrame
dat_tr <- trim_osmdata (dat, bb_sp)

# Server-side trimming equivalent
bb <- getbb ("colchester uk", format_out = "osm_type_id")
query <- opq (bb) |>
    add_osm_feature (key = "highway")
dat <- osmdata_sf (query, quiet = FALSE)
}
}
\seealso{
Other transform: 
\code{\link{osm_elevation}()},
\code{\link{osm_poly2line}()},
\code{\link{unique_osmdata}()},
\code{\link{unname_osmdata_sf}()}
}
\concept{transform}
