#' Zika in Girardot, Colombia, 2015
#'
#' These data describe the daily incidence of Zika virus disease in Girardot,
#' Colombia.
#'
#' @docType data
#'
#' @format {
#' A data frame with 93 rows and 2 columns
#' \describe{
#'   \item{date}{Date}
#'   \item{cases}{Daily incidence}
#' }
#'
#' The data on Zika virus disease incidence reported by Rojas et al. (2016)
#' cover the period from October 2015 to January 2016, over which time a total
#' of 1936 cases were reported to health authorities of Girardot (population of
#' 102,225). Suspected cases were confirmed by reverse transcription-polymerase
#' chain reaction (RT-PCR) in the serum of acute cases within five days of
#' symptom onset.
#'
#' }
#' @rdname zika_girardot_2015
#'
#' @author Data from Rojas et al. (2016), provided by Diana P. Rojas
#' (\email{dprojas@@epi.ufl.edu}).  Transfer to R and documentation by
#' Finlay Campbell (\email{finlaycampbell93@@gmail.com}).
#'
#' @source Rojas et al. (2016)
#'
#' @references
#'
#' Rojas, D. P., Dean, N. E., Yang, Y., Kenah, E., Quintero, J., Tomasi, S., ...
#' Eyrolle-Guignot, D. (2016). The epidemiology and transmissibility of Zika
#' virus in Girardot and San Andres island, Colombia, September 2015 to January
#' 2016. Eurosurveillance, 21(28), 30283.
#' \url{https://doi.org/10.2807/1560-7917.ES.2016.21.28.30283}
#'
#' These data were provided under a Creative Commons Attribution (CC BY 4.0)
#' Licence (\url{https://creativecommons.org/licenses/by/4.0/}).
#'
#' @examples
#' ## show first few days of Zika incidence
#' head(zika_girardot_2015)
#'
"zika_girardot_2015"
