% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtrack.R
\name{backtrack_lcwm}
\alias{backtrack_lcwm}
\title{Fit a linear cluster-weighted model to the backtrack solution.}
\usage{
backtrack_lcwm(
  xy,
  x,
  ombc_lcwm_out,
  max_total_rise = 0.1,
  max_step_rise = 0.05,
  init_z = NULL,
  manual_outlier_num = NULL,
  verbose = TRUE
)
}
\arguments{
\item{xy}{\code{data.frame} containing covariates and response.}

\item{x}{Covariate data only.}

\item{ombc_lcwm_out}{An \code{"outliermbc_lcwm"} object outputted by ombc_lcwm.}

\item{max_total_rise}{Upper limit for the cumulative increase, as a
proportion of the global minimum dissimilarity, from
all backward steps.}

\item{max_step_rise}{Upper limit for the increase, as a proportion of the
global minimum dissimilarity, from each backward step.}

\item{init_z}{Initial component assignment probability matrix.}

\item{manual_outlier_num}{User-specified number of outliers.}

\item{verbose}{Whether the iteration count is printed.}
}
\value{
\code{backtrack_gmm} returns a list with the following elements:
\describe{
\item{\code{labels}}{Vector of component labels with outliers denoted by 0.}
\item{\code{outlier_bool}}{Logical vector indicating if an observation has been
classified as an outlier.}
\item{\code{outlier_num}}{Number of observations classified as outliers.}
\item{\code{lcwm}}{Output from flexCWM::cwm fitted to the non-outlier
observations.}
\item{\code{call}}{Arguments / parameter values used in this function call.}
}
}
\description{
The \link{backtrack} function determines the number of outliers for the backtrack
solution and \link{plot_backtrack} plots this on a dissimilarity curve.
\code{backtrack_gmm} fits the mixture model corresponding to the number of
outliers selected by the backtrack solution (or any manually specified number
of outliers).
}
\examples{
gross_lcwm_k3n1000o10 <- find_gross(lcwm_k3n1000o10, 20)

ombc_lcwm_k3n1000o10 <- ombc_lcwm(
  xy = lcwm_k3n1000o10[, c("X1", "Y")],
  x = lcwm_k3n1000o10$X1,
  y_formula = Y ~ X1,
  comp_num = 2,
  max_out = 20,
  mnames = "V",
  gross_outs = gross_lcwm_k3n1000o10$gross_bool
)

backtrack_lcwm_k3n1000o10 <- backtrack_lcwm(
  xy = lcwm_k3n1000o10[, c("X1", "Y")],
  x = lcwm_k3n1000o10$X1,
  ombc_lcwm_out = ombc_lcwm_k3n1000o10
)
}
