% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_ate.R
\name{calculate_ate}
\alias{calculate_ate}
\title{Calculate Average Treatment Effect}
\usage{
calculate_ate(mean_comp, mean_ref, effect)
}
\arguments{
\item{mean_comp, mean_ref}{Mean of the outcome for the comparator and reference / common}

\item{effect}{A character string specifying the effect scale. Options are:
\describe{
\item{"log_odds"}{Log-odds difference.}
\item{"risk_difference"}{Risk difference.}
\item{"delta_z"}{Probit scale difference (z-scores).}
\item{"log_relative_risk_rare_events"}{Log relative risk for rare events.}
\item{"log_relative_risk"}{Log relative risk.}
}}
}
\value{
Numeric computed average treatment effect on the specified scale.
}
\description{
Computes the average treatment effect (ATE) based on the specified effect scale.
}
\examples{
calculate_ate(mean_comp = 0.7, mean_ref = 0.5, effect = "log_odds")
calculate_ate(mean_comp = 0.7, mean_ref = 0.5, effect = "risk_difference")

}
