% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comapre.R
\name{pac_compare_news}
\alias{pac_compare_news}
\title{Compare NEWS files between specific CRAN packages versions}
\usage{
pac_compare_news(
  pac,
  old = NULL,
  new = NULL,
  lib.loc = .libPaths(),
  repos = "https://cran.rstudio.com/"
)
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{old}{\code{character} an old version of package, default local version. Default: \code{NULL}}

\item{new}{\code{character} a new version of package, default newest version. Default: \code{NULL}}

\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{repos}{\code{character} vector repositories URLs to use. Used only for the validation. Default \verb{https://cran.rstudio.com/}}
}
\value{
\code{character} with NEWS content between specific versions.
}
\description{
using the remote github CRAN mirror to compare NEWS files between specific packages versions.
}
\examples{
\dontrun{
pacs::pac_compare_news("shiny", "1.0.0", "1.6.0")
# local version to newest one
pacs::pac_compare_news("shiny")
}
}
