% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.plot.R
\name{plot_techmix}
\alias{plot_techmix}
\title{Create a techmix plot}
\usage{
plot_techmix(data)
}
\arguments{
\item{data}{A data frame like the output of \code{prep_techmix()}.}
}
\value{
An object of class "ggplot".
}
\description{
Create a techmix plot
}
\examples{
# plot with `qplot_techmix()` parameters
data <- subset(
  market_share_demo,
  scenario_source == "demo_2020" &
    sector == "power" &
    region == "global" &
    metric \%in\% c("projected", "corporate_economy", "target_sds")
)
data <- prep_techmix(
  data,
  span_5yr = TRUE,
  convert_label = recode_metric_techmix,
  convert_tech_label = spell_out_technology
)

plot_techmix(data)
}
\seealso{
Other plotting functions: 
\code{\link{plot_emission_intensity}()},
\code{\link{plot_trajectory}()},
\code{\link{prep_emission_intensity}()},
\code{\link{prep_techmix}()},
\code{\link{prep_trajectory}()},
\code{\link{qplot_emission_intensity}()},
\code{\link{qplot_techmix}()},
\code{\link{qplot_trajectory}()},
\code{\link{recode_metric_techmix}()},
\code{\link{recode_metric_trajectory}()},
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()},
\code{\link{scale_fill_r2dii}()},
\code{\link{scale_fill_r2dii_sector}()},
\code{\link{scale_fill_r2dii_tech}()},
\code{\link{spell_out_technology}()},
\code{\link{theme_2dii}()},
\code{\link{to_title}()}
}
\concept{plotting functions}
