% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anthropic_batch_api.R
\name{anthropic_poll_batch_until_complete}
\alias{anthropic_poll_batch_until_complete}
\title{Poll an Anthropic Message Batch until completion}
\usage{
anthropic_poll_batch_until_complete(
  batch_id,
  interval_seconds = 60,
  timeout_seconds = 86400,
  api_key = Sys.getenv("ANTHROPIC_API_KEY"),
  anthropic_version = "2023-06-01",
  verbose = TRUE
)
}
\arguments{
\item{batch_id}{Character scalar giving the batch ID.}

\item{interval_seconds}{Polling interval in seconds. Defaults to 60.}

\item{timeout_seconds}{Maximum total waiting time in seconds. Defaults to
24 hours (\code{86400} seconds).}

\item{api_key}{Optional Anthropic API key. Defaults to
\code{Sys.getenv("ANTHROPIC_API_KEY")}.}

\item{anthropic_version}{Anthropic API version string passed as the
\code{anthropic-version} HTTP header. Defaults to \code{"2023-06-01"}.}

\item{verbose}{Logical; if \code{TRUE}, prints progress messages.}
}
\value{
The final Message Batch object as returned by
\code{\link{anthropic_get_batch}} once \code{processing_status == "ended"}
or the last object retrieved before timing out.
}
\description{
This helper repeatedly calls \code{\link{anthropic_get_batch}} until
the batch's \code{processing_status} becomes \code{"ended"} or a time
limit is reached. It is analogous to
\code{openai_poll_batch_until_complete()} but for Anthropic's
Message Batches API.
}
\examples{
\dontrun{
# Requires ANTHROPIC_API_KEY and network access.
batch <- anthropic_create_batch(requests = my_requests)
final <- anthropic_poll_batch_until_complete(batch$id, interval_seconds = 30)
final$processing_status
}

}
