% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lat_bins_degrees.R
\name{lat_bins}
\alias{lat_bins}
\title{Generate equal-width latitudinal bins}
\usage{
lat_bins(size = 10, min = -90, max = 90, fit = FALSE, plot = FALSE)
}
\arguments{
\item{size}{\code{numeric}. A single numeric value defining the width of the
latitudinal bins. This value must be more than 0, and less than or equal to
90 (defaults to 10).}

\item{min}{\code{numeric}. A single numeric value defining the lower limit
of the latitudinal range (defaults to -90).}

\item{max}{\code{numeric}. A single numeric value defining the upper limit
of the latitudinal range (defaults to 90).}

\item{fit}{\code{logical}. Should bin size be checked to ensure that the
entire latitudinal range is covered? If \code{fit = TRUE}, bin size is
set to the nearest integer which is divisible by the user-input range.
If \code{fit = FALSE}, and bin size is not divisible into the range, the
upper part of the latitudinal range will be missing.}

\item{plot}{\code{logical}. Should a plot of the latitudinal bins be
generated? If \code{TRUE}, a plot is generated. Defaults to \code{FALSE}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{lat_bins()} was renamed to \code{lat_bins_degrees()} to be consistent
with \verb{lat_bins_area().}
}
