% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lat_bins_degrees.R
\name{lat_bins_degrees}
\alias{lat_bins_degrees}
\title{Generate equal-width latitudinal bins}
\usage{
lat_bins_degrees(size = 10, min = -90, max = 90, fit = FALSE, plot = FALSE)
}
\arguments{
\item{size}{\code{numeric}. A single numeric value defining the width of the
latitudinal bins. This value must be more than 0, and less than or equal to
90 (defaults to 10).}

\item{min}{\code{numeric}. A single numeric value defining the lower limit
of the latitudinal range (defaults to -90).}

\item{max}{\code{numeric}. A single numeric value defining the upper limit
of the latitudinal range (defaults to 90).}

\item{fit}{\code{logical}. Should bin size be checked to ensure that the
entire latitudinal range is covered? If \code{fit = TRUE}, bin size is
set to the nearest integer which is divisible by the user-input range.
If \code{fit = FALSE}, and bin size is not divisible into the range, the
upper part of the latitudinal range will be missing.}

\item{plot}{\code{logical}. Should a plot of the latitudinal bins be
generated? If \code{TRUE}, a plot is generated. Defaults to \code{FALSE}.}
}
\value{
A \code{dataframe} of latitudinal bins of user-defined size. The
\code{data.frame} contains the following columns: bin (bin number), min
(minimum latitude of the bin), mid (midpoint latitude of
the bin), max (maximum latitude of the bin).
}
\description{
A function to generate latitudinal bins of a given size for a user-defined
latitudinal range. If the desired size of the bins is not compatible with
the defined latitudinal range, bin size can be updated to the nearest integer
which is divisible into this range.
}
\section{Developer(s)}{

Lewis A. Jones
}

\section{Reviewer(s)}{

Bethany Allen
}

\examples{
# Generate 20 degrees latitudinal bins
bins <- lat_bins_degrees(size = 20)

# Generate latitudinal bins with closest fit to 13 degrees
bins <- lat_bins_degrees(size = 13, fit = TRUE)

# Generate latitudinal bins for defined latitudinal range
bins <- lat_bins_degrees(size = 10, min = -50, max = 50)
}
\seealso{
For equal-area latitudinal bins, see \link{lat_bins_area}.
}
