% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateImplicitParameters.R
\name{calculateImplicitParameters}
\alias{calculateImplicitParameters}
\title{Calculate Implicit Parameters for Modeling Time-Series of Fossil Assemblages}
\usage{
calculateImplicitParameters(
  eventChangeScale,
  bgGradientValue,
  fullGradientRange,
  eventSampleWidthRatio = NULL,
  sampleWidth = NULL,
  eventDuration = NULL,
  sedRatePerTimestep = NULL,
  maxSampleTimeStep = 500,
  minSampleTimeStep = 3,
  samplingCompleteness,
  transitionDurationRatio,
  bioturbDepthRatio
)
}
\arguments{
\item{eventChangeScale}{A value indicating the amount relative to 
the background value (\code{bgGradientValue}) and the maximum 
possible change as indicated by \code{fullGradientRange} 
(in other words, simulated change must be within observed gradient, 
so \code{eventChangeScale} is a proportional multiplier of 
the total possible change).}

\item{bgGradientValue}{The gradient value expected during 
background intervals during which no notable excursion is 
occurring on that environmental gradient.}

\item{fullGradientRange}{A vector of two values giving the minimum 
and maximum gradient values observed in the empirical data.}

\item{eventSampleWidthRatio}{How long should an event be relative 
to the amount of time (or sediment) captured within a sedimentary sample? 
This parameter is used for simulating event duration, 
sample width and sedimentation rate where any two of these three 
are defined and the third is not defined. 
This value is referred to as \emph{Resolution Potential} 
in Belanger & Bapst (2023).}

\item{sampleWidth}{The 'width' of a sample relative to core depth 
or outcrop height, usually given in linear units (usually centimeters). 
For taking sediment samples from a core, this is straightforward 
(how thick is each sediment sample taken?) but for outcrops this 
may be more difficult to determine 
(what is the thickness of a horizon in a shale unit?).}

\item{eventDuration}{The duration (in time-units) of a 
simulated event during which the environmental gradient 
is at an excursion 'peak' level.}

\item{sedRatePerTimestep}{The rate of sedimentation, given as a 
ratio of sediment thickness (given in linear dimensions, 
in the same units as \code{sampleWidth}), over time 
(given in the same time units as \code{eventDuration}.}

\item{maxSampleTimeStep}{The maximum number of individual time-steps 
used for simulating a sample.}

\item{minSampleTimeStep}{The minimum number of individual time-steps 
used for simulating a sample.}

\item{samplingCompleteness}{The relative completeness of stratigraphic 
sampling. For example, if two-centimeter wide samples of sediment are 
taken from a sediment core, every ten centimeters, then the 
\code{samplingCompleteness} is two over 10, or that
\code{samplingCompleteness = 1/5}. A simulation with a sampling 
completeness of 1 would be comparable to exhaustively sampling a 
core that recorded no gaps in sedimentation over its history. 
Rocky outcrops are more complicated, as fossil-bearing horizons 
may be relatively thin compared to the thickness of the section, 
such that outcrop-based fossil records should be simulated as 
having \emph{very low} \code{samplingCompleteness}.}

\item{transitionDurationRatio}{The ratio of how long the transition 
between peak and background intervals should be, relative to the 
length of the peak 'event' duration (\code{eventDuration}). 
The longer this transition interval, the more chances of 
an assemblage being sampled that represents transitional gradient values.}

\item{bioturbDepthRatio}{The ratio of the sediment depth to which 
bioturbation occurs, made relative to the width of a 
sediment sample (\code{sampleWidth}). 
A \code{sampleWidth} of 3 cm and a \code{biotubDepthRatio} 
of 5 implies a bioturbation depth of 15 cm (\code{3 * 5}).  
Bioturbation depth varies considerably in the modern ocean, but is 
often the depth of active bioturbation is about 10 cm, such that the 
top ten centimeters of sediment 
(and the organic remains in those ten centimeters of sediment) 
are being regularly moved up and down by organism activity. 
For the purposes of this model, a bioturbation zone depth of 
10 centimeters means that sampling a centimeter of sediment 
at location X, the apparent fossil assemblage that would be 
recovered is just as likely to include specimens that were 
deposited five centimeters away as those deposited at location X.}
}
\value{
Returns a list giving the full set of parameters necessary for running \code{\link{simulateFossilAssemblageSeries}}.
}
\description{
Given a sufficient set of parameters for simulating fossil assemblages 
as a time-series, this function calculates the full set of parameters
necessary for running each component model.
}
\details{
Under the models considered in \code{paleoAM}, some parameterizations 
may be equivalent, even though the a particular analysis might 
be better simulated using a particular set of parameters. 
Allowing various different parameterizations is a useful 
generalization, but requires translating those equivalent parameters 
from one set to another (e.g. specifying parameters A, C & D, 
but running a simulation that requires parameters A, B & C).

This function mainly exists to calculate unspecified parameters 
for \code{\link{simulateFossilAssemblageSeries}} and also to 
identify conflicting parameter specifications.
}
\references{
Belanger, Christina L., and David W. Bapst. 2023.
"Simulating our ability to accurately detect abrupt 
changes in assemblage-based paleoenvironmental proxies." 
Palaeontologia Electronica 26 (2), 1-32
}
\seealso{
\code{\link{simulateFossilAssemblageSeries}}
}
