% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-template.R
\name{pandoc_export_template}
\alias{pandoc_export_template}
\title{Retrieve Pandoc template for a format}
\usage{
pandoc_export_template(format = "markdown", output = NULL, version = "default")
}
\arguments{
\item{format}{One of Pandoc format using a text template. (e.g html, latex, revealjs)}

\item{output}{Path where to save the file. If not provided, the default, template content will be print to the console.}

\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
If \code{output} is not provided, the content of the template will be
printed and return as one string (invisibly). If \code{output} is provided, the file path of
the output (invisibly).
}
\description{
This correspond to the \href{https://pandoc.org/MANUAL.html#option--print-default-template}{\code{--print-default-template} CLI flag}. With
this function, one can easily export default LaTeX template for example.
}
\examples{
\dontshow{if (pandoc::pandoc_available("2.7.1")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pandoc_export_template()
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{
withr::local_dir(withr::local_tempdir())
}
pandoc_export_template("latex", output = "default.tex", version = "system")
\dontshow{\}) # examplesIf}
}
