% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/captions.R
\name{find_caption}
\alias{find_caption}
\alias{drop_caption}
\alias{path_to_caption}
\title{Find or drop captions}
\usage{
find_caption(items)

drop_caption(items, idx = NULL)

path_to_caption(items)
}
\arguments{
\item{items}{A \link{LaTeX2} or other list of \link{LaTeX2item}s.}

\item{idx}{\code{NULL} or a vector of the same length as \code{items}}
}
\value{
\code{find_caption()} returns a \link{LaTeX2range} object
for any caption
text, with an attribute \code{extra} holding the range of
associated  macros and whitespace.

\code{drop_caption()} returns the \code{items} with
captions dropped as a \link{LaTeX2} object.  It has an attribute
named \code{idx} that is the \code{idx} argument with corresponding
elements dropped.

\code{path_to_caption()} returns a path
containing the location of the first caption
block within \code{items}.  It has an attribute \code{extra}
containing a \link{LaTeX2range} object for the
associated macros and whitespace.
}
\description{
Find or drop captions
}
\examples{
parsed <- parseLatex("before \\\\caption{This is a caption} \\\\\\\\ after")
idx <- find_caption(parsed)
get_range(parsed, idx)
get_range(parsed, attr(idx, "extra"))
drop_caption(parsed)
path_to_caption(parsed)
}
