% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/informationtheory_based.R
\name{mutualInformation}
\alias{mutualInformation}
\alias{mutualInformation,Partition,Partition-method}
\title{Mutual Information}
\usage{
mutualInformation(p, q)

\S4method{mutualInformation}{Partition,Partition}(p, q)
}
\arguments{
\item{p}{The partition \eqn{P}}

\item{q}{The partition \eqn{Q}}
}
\description{
Compute the mutual information
\deqn{
\sum_{C \in P} \sum_{D \in Q} {\frac{|C \cap D|}{n} \log n\frac{|C \cap D|}{|C| |D|}}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{mutualInformation(p = Partition, q = Partition)}: Compute given two partitions

}}
\examples{
isTRUE(all.equal(mutualInformation(new("Partition", c(0, 0, 0, 1, 1)), 
                 new("Partition", c(0, 0, 1, 1, 1))), 4/5*log(5/3) + 1/5*log(5/9)))

}
\references{
\insertRef{Vinh2010}{partitionComparison}
}
\seealso{
\code{\link{normalizedMutualInformation}}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
