% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_partial_time_ops.R
\name{Ops.partial_time}
\alias{Ops.partial_time}
\title{Handler for Ops generics for partial_time objects}
\usage{
\method{Ops}{partial_time}(e1, e2)
}
\arguments{
\item{e1}{objects}

\item{e2}{objects}
}
\value{
the binary operator result of \code{partial_time} \code{e1} with \code{e2}. See
Details for more information on operator behaviors.
}
\description{
Handler for Ops generics for partial_time objects
}
\details{
\code{partial_time} objects only implement binary operators \code{==} and \code{!=}. For
other operators, \code{partial_time}s are first converted to \code{partial_timespan}s
for operator evaluation.
}
\examples{
#                 when assume_tz "GMT"         when assume_tz NA
#                 ---------------------------  ---------------------------
#                 raw    possibly  definitely  raw   possibly  definitely
#                 -----  --------- ----------  ----- --------- -----------
#     1998 < 1999 TRUE   TRUE      TRUE        NA    TRUE      FALSE
#     1998 < 1997 FALSE  FALSE     FALSE       NA    TRUE      FALSE
#     1999 < 1999 NA     TRUE      FALSE       NA    TRUE      FALSE
# 1998 < 1999/1/3 TRUE   TRUE      TRUE        TRUE  TRUE      TRUE

parttime(1998) < parttime(1999)
parttime(1998) < parttime(1997)
parttime(1999) < parttime(1999)
parttime(1998) < parttime(1999, 1, 3)

}
\seealso{
possibly definitely
}
