% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_create_connection}
\alias{datazone_create_connection}
\title{Creates a new connection}
\usage{
datazone_create_connection(
  awsLocation = NULL,
  clientToken = NULL,
  description = NULL,
  domainIdentifier,
  environmentIdentifier,
  name,
  props = NULL
)
}
\arguments{
\item{awsLocation}{The location where the connection is created.}

\item{clientToken}{A unique, case-sensitive identifier that is provided to ensure the
idempotency of the request.}

\item{description}{A connection description.}

\item{domainIdentifier}{[required] The ID of the domain where the connection is created.}

\item{environmentIdentifier}{[required] The ID of the environment where the connection is created.}

\item{name}{[required] The connection name.}

\item{props}{The connection props.}
}
\description{
Creates a new connection. In Amazon DataZone, a connection enables you to connect your resources (domains, projects, and environments) to external resources and services.

See \url{https://www.paws-r-sdk.com/docs/datazone_create_connection/} for full documentation.
}
\keyword{internal}
