% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_replace_root_volume_tasks}
\alias{ec2_describe_replace_root_volume_tasks}
\title{Describes a root volume replacement task}
\usage{
ec2_describe_replace_root_volume_tasks(
  ReplaceRootVolumeTaskIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL
)
}
\arguments{
\item{ReplaceRootVolumeTaskIds}{The ID of the root volume replacement task to view.}

\item{Filters}{Filter to use:
\itemize{
\item \code{instance-id} - The ID of the instance for which the root volume
replacement task was created.
}}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes a root volume replacement task. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html}{Replace a root volume} in the \emph{Amazon EC2 User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_replace_root_volume_tasks/} for full documentation.
}
\keyword{internal}
