% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/savingsplans_operations.R
\name{savingsplans_create_savings_plan}
\alias{savingsplans_create_savings_plan}
\title{Creates a Savings Plan}
\usage{
savingsplans_create_savings_plan(
  savingsPlanOfferingId,
  commitment,
  upfrontPaymentAmount = NULL,
  purchaseTime = NULL,
  clientToken = NULL,
  tags = NULL
)
}
\arguments{
\item{savingsPlanOfferingId}{[required] The ID of the offering.}

\item{commitment}{[required] The hourly commitment, in the same currency of the
\code{savingsPlanOfferingId}. This is a value between 0.001 and 1 million.
You cannot specify more than five digits after the decimal point.}

\item{upfrontPaymentAmount}{The up-front payment amount. This is a whole number between 50 and 99
percent of the total value of the Savings Plan. This parameter is only
supported if the payment option is \verb{Partial Upfront}.}

\item{purchaseTime}{The purchase time of the Savings Plan in UTC format
(YYYY-MM-DDTHH:MM:SSZ).}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{tags}{One or more tags.}
}
\description{
Creates a Savings Plan.

See \url{https://www.paws-r-sdk.com/docs/savingsplans_create_savings_plan/} for full documentation.
}
\keyword{internal}
