% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessanalyzer_operations.R
\name{accessanalyzer_get_generated_policy}
\alias{accessanalyzer_get_generated_policy}
\title{Retrieves the policy that was generated using StartPolicyGeneration}
\usage{
accessanalyzer_get_generated_policy(
  jobId,
  includeResourcePlaceholders = NULL,
  includeServiceLevelTemplate = NULL
)
}
\arguments{
\item{jobId}{[required] The \code{JobId} that is returned by the
\code{\link[=accessanalyzer_start_policy_generation]{start_policy_generation}}
operation. The \code{JobId} can be used with
\code{\link[=accessanalyzer_get_generated_policy]{get_generated_policy}} to
retrieve the generated policies or used with
\code{\link[=accessanalyzer_cancel_policy_generation]{cancel_policy_generation}} to
cancel the policy generation request.}

\item{includeResourcePlaceholders}{The level of detail that you want to generate. You can specify whether
to generate policies with placeholders for resource ARNs for actions
that support resource level granularity in policies.

For example, in the resource section of a policy, you can receive a
placeholder such as \code{"Resource":"arn:aws:s3:::${BucketName}"} instead of
\code{"*"}.}

\item{includeServiceLevelTemplate}{The level of detail that you want to generate. You can specify whether
to generate service-level policies.

IAM Access Analyzer uses \code{iam:servicelastaccessed} to identify services
that have been used recently to create this service-level template.}
}
\description{
Retrieves the policy that was generated using \code{\link[=accessanalyzer_start_policy_generation]{start_policy_generation}}.

See \url{https://www.paws-r-sdk.com/docs/accessanalyzer_get_generated_policy/} for full documentation.
}
\keyword{internal}
