% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_create_bucket_metadata_table_configuration}
\alias{s3_create_bucket_metadata_table_configuration}
\title{Creates a metadata table configuration for a general purpose bucket}
\usage{
s3_create_bucket_metadata_table_configuration(
  Bucket,
  ContentMD5 = NULL,
  ChecksumAlgorithm = NULL,
  MetadataTableConfiguration,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The general purpose bucket that you want to create the metadata table
configuration in.}

\item{ContentMD5}{The \code{Content-MD5} header for the metadata table configuration.}

\item{ChecksumAlgorithm}{The checksum algorithm to use with your metadata table configuration.}

\item{MetadataTableConfiguration}{[required] The contents of your metadata table configuration.}

\item{ExpectedBucketOwner}{The expected owner of the general purpose bucket that contains your
metadata table configuration.}
}
\description{
Creates a metadata table configuration for a general purpose bucket. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/metadata-tables-overview.html}{Accelerating data discovery with S3 Metadata} in the \emph{Amazon S3 User Guide}.

See \url{https://www.paws-r-sdk.com/docs/s3_create_bucket_metadata_table_configuration/} for full documentation.
}
\keyword{internal}
