% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{toLoo}
\alias{toLoo}
\title{Compute approximate leave-one-out (LOO) cross-validation for Bayesian
models using Pareto smoothed importance sampling (PSIS)}
\usage{
toLoo(fit, ...)
}
\arguments{
\item{fit}{a \code{\link[rstan:stanfit-class]{stanfit}} object}

\item{...}{Additional options passed to \code{\link[loo:loo]{loo}}.}
}
\value{
a loo object
}
\description{
You must use an \sQuote{_ll} model variation (see \code{\link{findModel}}).
}
\examples{
palist <- letters[1:10]
df <- twoLevelGraph(palist, 300)
theta <- rnorm(length(palist))
names(theta) <- palist
df <- generateItem(df, theta, th=rep(0.5, 4))

df <- filterGraph(df)
df <- normalizeData(df)
dl <- prepCleanData(df)
dl$scale <- 1.5

\donttest{
m1 <- pcStan("unidim_ll", dl)

loo1 <- toLoo(m1, cores=1)
print(loo1)
}
}
\seealso{
\code{\link{outlierTable}}, \code{\link[loo:loo]{loo}}
}
