% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSimUG2D.R
\name{CSedge.dens.test}
\alias{CSedge.dens.test}
\title{A test of segregation/association based on edge density
of underlying or reflexivity graph of Central Similarity Proximity Catch Digraph
(CS-PCD) for 2D data}
\usage{
CSedge.dens.test(
  Xp,
  Yp,
  t,
  ugraph = c("underlying", "reflexivity"),
  ch.cor = FALSE,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying
or reflexivity graphs of the CS-PCD.}

\item{Yp}{A set of 2D points
which constitute the vertices of the Delaunay triangles.}

\item{t}{A positive real number
which serves as the expansion parameter in CS proximity region.}

\item{ugraph}{The type of the graph based on CS-PCDs,
\code{"underlying"} is for the underlying graph,
and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}

\item{ch.cor}{A logical argument for convex hull correction,
default \code{ch.cor=FALSE},
recommended when both \code{Xp} and \code{Yp}
have the same rectangular support.}

\item{alternative}{Type of the alternative hypothesis in the test,
one of \code{"two.sided"}, \code{"less"}, \code{"greater"}.}

\item{conf.level}{Level of the confidence interval,
default is \code{0.95}, for the edge density of
underlying or reflexivity graphs of CS-PCD based on
the 2D data set \code{Xp}.}
}
\value{
A \code{list} with the elements
\item{statistic}{Test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test
for the corresponding \code{alternative}}
\item{conf.int}{Confidence interval for the edge density
at the given confidence level \code{conf.level} and
depends on the type of \code{alternative}.}
\item{estimate}{Estimate of the parameter, i.e., edge density}
\item{null.value}{Hypothesized value for the parameter,
i.e., the null edge density, which is usually the
mean edge density under uniform distribution.}
\item{alternative}{Type of the alternative hypothesis in the test,
one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set}
}
\description{
An object of class \code{"htest"} (i.e., hypothesis test) function
which performs a hypothesis test of complete spatial
randomness (CSR) or uniformity of \code{Xp} points
in the convex hull of \code{Yp} points against the alternatives
of segregation (where \code{Xp} points cluster
away from \code{Yp} points) and association
(where \code{Xp} points cluster around
\code{Yp} points) based on the normal approximation
of the edge density of the underlying or reflexivity graph of
CS-PCD for uniform 2D data.

The function yields the test statistic,
\eqn{p}-value for the corresponding \code{alternative},
the confidence interval, estimate
and null value for the parameter of interest
(which is the edge density),
and method and name of the data set used.

Under the null hypothesis of uniformity of \code{Xp} points
in the convex hull of \code{Yp} points, edge density
of underlying or reflexivity graph of CS-PCD
whose vertices are \code{Xp} points equals
to its expected value under the uniform distribution and
\code{alternative} could be two-sided, or left-sided
(i.e., data is accumulated around the \code{Yp} points, or association)
or right-sided (i.e., data is accumulated
around the centers of the triangles,
or segregation).

CS proximity region is constructed
with the expansion parameter \eqn{t > 0} and \eqn{CM}-edge regions
(i.e., the test is not available for a general center \eqn{M}
at this version of the function).

**Caveat:** This test is currently a conditional test,
where \code{Xp} points are assumed to be random,
while \code{Yp} points are
assumed to be fixed (i.e., the test is conditional on \code{Yp} points).
Furthermore,
the test is a large sample test when \code{Xp} points
are substantially larger than \code{Yp} points,
say at least 5 times more.
This test is more appropriate when supports of \code{Xp}
and \code{Yp} have a substantial overlap.
Currently, the \code{Xp} points
outside the convex hull of \code{Yp} points
are handled with a correction factor
which is derived under the assumption of
uniformity of \code{Xp} and \code{Yp} points in the study window,
(see the description below for the argument \code{ch.cor}
and the function code.)
However, in the special case of no \code{Xp} points
in the convex hull of \code{Yp} points,
edge density is taken to be 1,
as this is clearly a case of segregation.
Removing the conditioning and extending it to
the case of non-concurring supports is
an ongoing topic of research of the author of the package.

\code{ch.cor} is for convex hull correction
(default is \code{"no convex hull correction"}, i.e., \code{ch.cor=FALSE})
which is recommended
when both \code{Xp} and \code{Yp} have the same rectangular support.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph})
for more on the test based on the edge density of
underlying or reflexivity graphs of CS-PCDs.
}
\examples{
\donttest{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-100; ny<-5;

set.seed(1)
Xp<-cbind(runif(nx),runif(nx))
Yp<-cbind(runif(ny,0,.25),
runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))

pcds::plotDelaunay.tri(Xp,Yp,xlab="",ylab="")

CSedge.dens.test(Xp,Yp,t=1.5)
CSedge.dens.test(Xp,Yp,t=1.5,ch=TRUE)

CSedge.dens.test(Xp,Yp,t=1.5,ugraph="r")
CSedge.dens.test(Xp,Yp,t=1.5,ugraph="r",ch=TRUE)
#since Y points are not uniform, convex hull correction is invalid here

}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{PEedge.dens.test}} and \code{\link[pcds]{CSarc.dens.test}}
}
\author{
Elvan Ceyhan
}
