% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{plotASarcs}
\alias{plotASarcs}
\title{The plot of the arcs of Arc Slice Proximity Catch Digraph (AS-PCD)
for a 2D data set -
multiple triangle case}
\usage{
plotASarcs(
  Xp,
  Yp,
  M = "CC",
  asp = NA,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of
the Delaunay triangulation. The Delaunay
triangles partition the convex hull of \code{Yp} points.}

\item{M}{The center of the triangle.
\code{"CC"} stands for circumcenter of each Delaunay triangle
or 3D point in barycentric coordinates
which serves as a center in the interior of each Delaunay triangle;
default is \code{M="CC"} i.e., the circumcenter of each triangle.}

\item{asp}{A \code{numeric} value, giving the aspect ratio for \eqn{y} axis
to \eqn{x}-axis \eqn{y/x} (default is \code{NA}),
see the official help page for \code{asp} by typing "\code{? asp}".}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes,
respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2,
giving the \eqn{x}- and \eqn{y}-coordinate ranges
(default=\code{NULL} for both).}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
A plot of the arcs of the AS-PCD for a 2D data set \code{Xp}
where AS proximity regions
are defined with respect to the Delaunay triangles based on \code{Yp} points;
also plots the Delaunay triangles
based on \code{Yp} points.
}
\description{
Plots the arcs of AS-PCD whose vertices are the data points
in \code{Xp} and Delaunay triangles based on \code{Yp} points.

AS proximity regions are constructed with respect to the Delaunay triangles
based on \code{Yp} points, i.e.,
AS proximity regions are defined only for \code{Xp} points
inside the convex hull of \code{Yp} points.
That is, arcs may exist for \code{Xp} points only
inside the convex hull of \code{Yp} points.
If there are duplicates of \code{Xp} points,
only one point is retained for each duplicate value,
and a warning message is printed.

Vertex regions are based on the center \code{M="CC"}
for circumcenter of each Delaunay triangle or \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the
interior of each Delaunay triangle; default is \code{M="CC"} i.e.,
circumcenter of each triangle.
When the center is the circumcenter, \code{CC},
the vertex regions are constructed based on the
orthogonal projections to the edges,
while with any interior center \code{M},
the vertex regions are constructed using the extensions
of the lines combining vertices with \code{M}.

Convex hull of \code{Yp} is partitioned by
the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles
whose union constitutes the
convex hull of \code{Yp} points).
Loops are not allowed so arcs are only possible
for points inside the convex hull of \code{Yp} points.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds})
for more on AS-PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
\donttest{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-15; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

plotASarcs(Xp,Yp,M,asp=1,xlab="",ylab="")

plotASarcs(Xp,Yp[1:3,],M,asp=1,xlab="",ylab="")
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotASarcs.tri}}, \code{\link{plotPEarcs.tri}}, \code{\link{plotPEarcs}},
\code{\link{plotCSarcs.tri}}, and \code{\link{plotCSarcs}}
}
\author{
Elvan Ceyhan
}
