% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcev.R
\docType{data}
\name{methylation}
\alias{methylation}
\alias{pheno}
\alias{position}
\alias{index}
\alias{pheno2}
\alias{position2}
\alias{methylation2}
\title{Methylation values around BLK gene}
\format{The data comes in four objects: 
\describe{ 
\item{methylation}{Matrix of methylation
  values at 5,986 sites measured on 40 samples} 
\item{pheno}{Vector of phenotype, indicating
  whether the sample comes from a B cell} 
\item{position}{Data frame recording the position of
  each CpG site along the chromosome} 
\item{index}{Index vector used in the computation of
  PCEV-block} 
\item{methylation2}{Matrix of methylation values at 1000 sites measured on 40
  samples} 
\item{pheno2}{Vector of phenotype, indicating the cell type of the sample (B cell, T cell, or Monocyte)} 
\item{position2}{Data frame recording the position of each CpG site along the chromosome} }}
\source{
Tomi Pastinen, McGill University, Genome Quebec.
}
\usage{
methylation

pheno

position

index

pheno2

position2

methylation2
}
\description{
A dataset containing methylation values for cell-separated samples. The methylation was measured
using bisulfite sequencing. The data also contains the genomic position of these CpG sites, as
well as a binary phenotype (i.e. whether the sample comes from a B cell).
}
\details{
Methylation was first measured at 24,068 sites, on 40 samples. Filtering was performed to keep
the 25\% most variable sites. See the vignette for more detail.

A second sample of the methylation dataset was extracted. This second dataset contains
methylation values at 1000 CpG dinucleotides.
}
\keyword{datasets}
