% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrend_B.R
\name{detrend_B}
\alias{detrend_B}
\title{detrend_B}
\usage{
detrend_B(x, x_values, y, detrend_B_position = "center")
}
\arguments{
\item{x}{factor vector to indicate conditions or phases (e.g., "A" and "B")}

\item{x_values}{numerical vector with distance (time markers) between observations}

\item{y}{numeric vector with the observed y-values}

\item{detrend_B_position}{character to indicate the mean}
}
\value{
List with the trend and the detrended y values:
  x_values_B_trend = vector with distance (time markers) between B-detrended signal,
  y_B_trend = vector with computed B-trend,
  y_detrended = vector with computed B-detrended y values.
}
\description{
Detrends the phase B part of time series y.
detrend B is optional and not validated.
The mean of the detrended signal will be set to the predicted value based on detrend_B_position:
detrend_B_position = "first" : take predicted value for first valid observation
detrend_B_position = "center" : take predicted value for center observation
detrend_B_position = "last" : take predicted value for last valid observation.
}
\examples{
pdt::detrend_B(as.factor(c(rep("A",20), rep("B",20))), 1:40,
  c(rnorm(20), rnorm(20)+2), detrend_B_position="center")

}
