% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_persistence.R
\name{global_persistence}
\alias{global_persistence}
\title{global persistence}
\usage{
global_persistence(vertex, edge_list, weights, membership, H0 = TRUE)
}
\arguments{
\item{vertex}{the vertices of the graph, whose label are integers and they must be consistent with the edge sets.}

\item{edge_list}{the graph edge list in the form of an integer matrix with two columns.}

\item{weights}{the graph edge weights.}

\item{membership}{An integer vector representing the vertex membership:  x_i = k if i in C_k.}

\item{H0}{If true, it calculates the null-adjusted persistence, if false, the persistence probability.}
}
\value{
value
A list containing the following:
\describe{
\item{value}{The global persistence of the partition.}
\item{clusters_value}{The local persistence of each cluster. If for some k we have v_k = NaN, then
C_k is empty in the input membership.}
}
}
\description{
Given a partition of the graph vertices, it calculates the global persistence as the sum of the persistences
of the single clusters. Persistence can be referred to the null-adjusted o to the probability.
}
\examples{
library(persistence)
library(igraph)

edg = c(1, 2, 1, 3, 1, 4, 2, 3, 3, 4, 4, 5, 5, 6, 5, 7, 5, 8, 5, 9, 6, 7, 6, 8, 7, 9, 8, 9)
vertex = unique(edg)
edg = t(matrix(as.integer(edg), nrow = 2 ))
rete <- graph_from_edgelist(edg, directed = FALSE) # I graph this matrix
plot(rete)

membership = c(1, 1, 1, 1, 2, 2, 2, 2, 2)
v1 = global_persistence(vertex, edg, weights=NULL, membership, H0=TRUE)
print(paste("global null-adjusted persistence: ", v1$value))
print(paste("null-adjusted persistence per cluster: ", v1$clusters_value))
}
