% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nomogrammer.R
\name{nomogrammer}
\alias{nomogrammer}
\title{Create Nomogram.}
\usage{
nomogrammer(
  TP = NULL,
  TN = NULL,
  FP = NULL,
  FN = NULL,
  pretestProb = NULL,
  selectionRate = NULL,
  SN = NULL,
  SP = NULL,
  FPR = NULL,
  PLR = NULL,
  NLR = NULL,
  Detail = FALSE,
  NullLine = FALSE,
  LabelSize = (14/5),
  Verbose = FALSE
)
}
\arguments{
\item{TP}{Number of true positive cases.}

\item{TN}{Number of true negative cases.}

\item{FP}{Number of false positive cases.}

\item{FN}{Number of false negative cases.}

\item{pretestProb}{Pretest probability (prevalence/base rate/prior
probability) of characteristic, as a number between 0 and 1.}

\item{selectionRate}{Selection rate (marginal probability of positive test),
as a number between 0 and 1.}

\item{SN}{Sensitivity of the test at a given cut point, as a number
between 0 and 1.}

\item{SP}{Specificity of the test at a given cut point, as a number
between 0 and 1.}

\item{FPR}{False positive rate of the test at a given cut point, as a number
between 0 and 1.}

\item{PLR}{Positive likelihood ratio of the test at a given cut point.}

\item{NLR}{Positive likelihood ratio of the test at a given cut point.}

\item{Detail}{If \code{TRUE}, overlay key statistics onto the plot.}

\item{NullLine}{If \code{TRUE}, add a line from prior prob through LR = 1.}

\item{LabelSize}{Label size.}

\item{Verbose}{Print out relevant metrics in the console.}
}
\value{
ggplot object of nomogram plot.
}
\description{
Create nomogram plot.
}
\details{
Create nomogram plot from the following at a given cut point:

\itemize{
  \item 1) true positives (TP), true negatives (TN), false positives (FP),
  and false negatives (FN)
  \item 2) pretest probability (pretestProb), sensitivity (SN), and
  specificity (SP), OR
  \item 3) pretest probability (pretestProb), sensitivity (SN), and
  false positive rate (FPR), OR
  \item 4) pretest probability (pretestProb), sensitivity (SN), and
  selection rate (selectionRate), OR
  \item 5) pretest probability (pretestProb), positive likelihood ratio
  (PLR), and negative likelihood ratio (NLR)
}
}
\examples{

nomogrammer(
  TP = 253,
  TN = 386,
  FP = 14,
  FN = 347)

nomogrammer(
  pretestProb = .60,
  SN = 0.421,
  SP = 0.965)

nomogrammer(
  pretestProb = .60,
  SN = 0.421,
  FPR = 0.035)

nomogrammer(
  pretestProb = .60,
  SN = 0.421,
  selectionRate = 0.267)

nomogrammer(
  pretestProb = .60,
  PLR = 12,
  NLR = 0.6)

}
\seealso{
\url{https://github.com/achekroud/nomogrammer}

Other accuracy: 
\code{\link{accuracyAtCutoff}()},
\code{\link{accuracyAtEachCutoff}()},
\code{\link{accuracyOverall}()},
\code{\link{optimalCutoff}()},
\code{\link{posttestOdds}()}
}
\concept{accuracy}
