% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequential_monitor.R
\name{bayes.design}
\alias{bayes.design}
\title{Bayesian design method for sequentially monitoring patients using Beta-Binomial posterior probability based on observing data}
\usage{
bayes.design(a,b,r=0, stop.rule="futility", add.size=5, alpha=0.05,
p0 ,delta=0.2,tau1=0.9,tau2=0.9,tau3=0.9,tau4=0.9, time.interval =1)
}
\arguments{
\item{a}{the hyperparameter (shape1) of the Beta prior for the experimental drug.}

\item{b}{the hyperparameter (shape2) of the Beta prior for the experimental drug.}

\item{r}{the maximum number of patients treated by the experimental drug.}

\item{stop.rule}{the hyperparameter (shape1) of the Beta prior for the experimental drug.}

\item{add.size}{a single integer value, random number generator (RNG) state for random number generation.}

\item{alpha}{the siginificant level to determine the credible interval, set 0.05 by default.}

\item{p0}{the prespecified reseponse rate.}

\item{delta}{the minimally acceptable increment of the response rate.}

\item{tau1}{threshold for stopping rule 1.}

\item{tau2}{threshold for stopping rule 2.}

\item{tau3}{threshold for stopping rule 3.}

\item{tau4}{threshold for stopping rule 4.}

\item{time.interval}{a positive number to set the time interval of the animation (unit in seconds); default to be 1.}
}
\value{
animation plot of determination of stopping boundaries.
}
\description{
Make animation plots to present sequential monitor stopping rule using Beta-Binomial Bayesian model
}
\examples{
# Using Multiple Myeloma (MM) data example
MM.r = rep(0,6); MM.mean = 0.1; MM.var = 0.0225
a <- MM.mean^2*(1-MM.mean)/MM.var - MM.mean; b <- MM.mean*(1-MM.mean)^2/MM.var - (1-MM.mean)
bayes.design(a=a,b=b,r=MM.r,stop.rule="futility",p0=0.1)

# Using Acute Promyelocytic Leukaemia (APL) data example
APL.r <- c(0,1,0,0,1,1); APL.mean = 0.3; APL.var = 0.0191
a <- APL.mean^2*(1-APL.mean)/APL.var - APL.mean; b <- APL.mean*(1-APL.mean)^2/APL.var - (1-APL.mean)
bayes.design(a=a,b=b,r=APL.r,stop.rule="efficacy",p0=0.1)
}
\references{
Yin, G. (2012).
\emph{Clinical Trial Design: Bayesian and Frequentist Adaptive Methods.}
New York: Wiley.
}

