% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-tuv-file.r
\name{qtuv_s.e.irrad}
\alias{qtuv_s.e.irrad}
\alias{qtuv_m_s.e.irrad}
\title{Spectral irradiance from the Quick TUV calculator}
\usage{
qtuv_s.e.irrad(
  w.length = list(wStart = 280, wStop = 420, wIntervals = 140),
  sun.elevation = NULL,
  geocode = data.frame(lon = 0, lat = 51.5, address = "Greenwich"),
  time = lubridate::now(),
  tz = NULL,
  locale = readr::default_locale(),
  ozone.du = 300,
  albedo = 0.1,
  ground.altitude = 0,
  measurement.altitude = NULL,
  clouds = data.frame(optical.depth = 0, base = 4, top = 5),
  aerosols = data.frame(optical.depth = 0.235, ssaaer = 0.99, alpha = 1),
  num.streams = 2,
  spectra = list(direct = 1, diffuse.down = 1, diffuse.up = 0),
  added.vars = NULL,
  label = "",
  server.url = "https://www.acom.ucar.edu/cgi-bin/acom/TUV/V5.3/tuv",
  file = NULL
)

qtuv_m_s.e.irrad(
  w.length = list(wStart = 280, wStop = 420, wIntervals = 140),
  sun.elevation = NULL,
  geocode = data.frame(lon = 0, lat = 51.5, address = "Greenwich"),
  time = lubridate::now(),
  tz = NULL,
  locale = readr::default_locale(),
  ozone.du = 300,
  albedo = 0.1,
  ground.altitude = 0,
  measurement.altitude = NULL,
  clouds = data.frame(optical.depth = 0, base = 4, top = 5),
  aerosols = data.frame(optical.depth = 0.235, ssaaer = 0.99, alpha = 1),
  num.streams = 2,
  spectra = list(direct = 1, diffuse.down = 1, diffuse.up = 0),
  added.vars = NULL,
  label = "",
  server.url = "https://www.acom.ucar.edu/cgi-bin/acom/TUV/V5.3/tuv",
  file = NULL
)
}
\arguments{
\item{w.length}{list of parameters describing the wavelengths, or a numeric
vector from which the parameters will be constructed.}

\item{sun.elevation}{numeric Angle in degrees above the horizon. If NULL its
value is computed from \code{geocode} and \code{time}, otherwise 
arguments passed to these two parameters are ignored.}

\item{geocode}{data.frame with variables \code{lon} and \code{lat} as numeric values
(degrees), and character variable \code{address}; nrow > 1, allowed for collections.}

\item{time}{A "vector" of POSIXct time, with any valid time zone (TZ) is
allowed, default is current time.}

\item{tz}{character Time zone is by default read from the file.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{ozone.du}{numeric Ozone column in Dobson units.}

\item{albedo}{numeric Surface albedo (= reflectance) as a fraction of one.}

\item{measurement.altitude, ground.altitude}{numeric Altitudes above sea level
expressed in km.}

\item{clouds}{data.frame Parameters \code{optical.depth} (vertical), \code{top} and 
\code{base} expressed in km; nrow > 1, allowed for collections.}

\item{aerosols}{data.frame Parameters \code{optical.depth} (total extinction), \code{ssaaer} 
(cloud single scattering albedo) and \code{alpha} (wavelength dependence of 
optical depth); nrow > 1, allowed for collections.}

\item{num.streams}{integer Number of streams used in computations, 2 or 4.}

\item{spectra}{named list with weights for the different components of the 
spectrum.}

\item{added.vars}{character vector Accepted member values are \code{"sun.elevation"},
\code{zenith.angle}, \code{"date"} and \code{"ozone.du"}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{server.url}{character The URL used to access the Quick TUV calculator
server.}

\item{file}{character The name under which the file returned by the server is
locally saved. If \code{NULL} a temporary file is used and discarded
immediately. File paths are supported when valid.}
}
\value{
In the case of \code{qtuv_s.e.irrad()}, a source_spct object obtained
  by finding the center of each wavelength interval in the Quick TUV output
  file, and adding the variables listed in \code{added.vars}. In the case of
  \code{qtuv_m_s.e.irrad()}, a source_mspct object containing a collection of
  such spectra.
}
\description{
Call the Quick TUV calculator web server and return a \code{source_spct}
object with the simulated spectral energy irradiance data.
}
\details{
The Quick TUV calculator, is an on-line freely accessible server
  running the TUV atmospheric chemistry and radiation transfer model with a
  simplified user interface. In this case, version 5.3 is called passing the
  parameter values passed as arguments in the call to
  \code{qtuv_s.e.irrad()}. The response is saved in a text file that is
  subsequently read with function \code{read_qtuv_txt()} into a
  \code{source_spct} object.
  
  Function \code{qtuv_m_s.e.irrad()} calls \code{qtuv_s.e.irrad()} repeatedly 
  accepting a numeric vector longer than one as argument, for parameters: 
  \code{sun.elevation}, \code{time} or \code{ozone.du}, and data frames with
  nrow >= 1. In a given call, only one parameter at a time can obey multiple 
  values, with others currently truncated to the first value.

  The formal parameter names are informative and consistent with other 
  functions in the R for Photobiology Suite and differ from the short names
  used for the parameters in the FORTRAN code of the TUV model. In the case
  of \code{w.length} two ways of specifying wavelengths are supported. Some
  defaults also differ from those of the Quick TUV calculator.
  
  In the current implementation, \code{qtuv_m_s.e.irrad()}, accepts multiple
  values as arguments for only one parameter at a time. In the case of
  elevation, both `ground.elevation` and `measurement.elevation` can have
  each one or more values. When too many values are passed in the call, only
  the first one is used.
}
\note{
The Quick TUV calculator has multiple output modes that return
  different types of computed values. The use of output mode 5 is hard-coded
  in this function as other modes return summary values rather than spectral
  data. Package 'foqat' provides a more flexible alternative supporting other
  output modes in addition to mode 5.
  
  If the argument passed to \code{w.length} is a numeric vector, the range
  and length are used to reconstruct the accepted parameters. The returned
  spectrum has always a uniformly spaced wavelengths.
  
  When using this function, more detailed metadata are available than when
  reading an output file, as not all the simulation input parameters are
  listed in the output text.
  
  In interactive use of the Quick TUV Calculator, the same parameters as
  accepted by \code{qtuv_s.e.irradiance()} as arguments are
  entered through the web interface at 
  \url{https://www.acom.ucar.edu/Models/TUV/Interactive_TUV/}. This page 
  together with its documentation, can be consulted for additional
  information on the parameters and the model.
}
\section{Side effect}{
 If a file name is passed as argument, the data as
  downloaded are saved into persistent files, one file per spectrum. The
  names of the saved files always end in `.txt`.
}

\section{Warning!}{
 This function connects to a server managed by UCAR, the
  University Corporation for Atmospheric Research located in the U.S.A. to
  obtain simulated spectral data. UCAR manages the U.S. National Science
  Foundation National Center for Atmospheric Research (NSF NCAR) on behalf of
  NSF. As any download with the HTTPS protocol, using this function entails
  some risk. To minimize the risk, the returned page is saved as plain text,
  checked for conformity with the expected content, and if valid decoded into
  an R data object. When using the default argument \code{file = NULL}, the
  file used is a temporary one and is deleted before the function returns the
  call, irrespective of it being conformant or not.

  The administrators of the Quick TUV Calculator at UCAR suggest a maximum
  load of approximately 100 spectral simulations per day and user. For larger
  workloads they encourage the local installation of the TUV model which is
  open-source and freely available. A local installation, also allows access
  to the full set of input parameters and outputs. Currently a local instance
  of the TUV model can be called from R with package 'foqat'.
}

\references{
\url{https://www.acom.ucar.edu/Models/TUV/Interactive_TUV/}. This
  URL could change in the future as well as the server URL. The formal
  parameter \code{server.url} was included only for use in such a case.

Sasha Madronich (2017-2021) Tropospheric Ultraviolet and Visible radiation (TUV) 
model. \url{https://www2.acom.ucar.edu/modeling/tropospheric-ultraviolet-and-visible-tuv-radiation-model}.
Visited on 2024-08-29.
}
