% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/led_colors.r
\docType{data}
\name{led_colors}
\alias{led_colors}
\alias{'leds}
\alias{by}
\alias{color'}
\alias{uv_leds}
\alias{purple_leds}
\alias{ir_leds}
\alias{blue_leds}
\alias{green_leds}
\alias{yellow_leds}
\alias{orange_leds}
\alias{red_leds}
\alias{amber_leds}
\alias{white_leds}
\alias{multi_channel_leds}
\alias{single_channel_leds}
\title{Spectral data for LEDs of different colours}
\format{
A vector of character strings.

An object of class \code{character} of length 18.

An object of class \code{character} of length 8.

An object of class \code{character} of length 6.

An object of class \code{character} of length 14.

An object of class \code{character} of length 10.

An object of class \code{character} of length 0.

An object of class \code{character} of length 4.

An object of class \code{character} of length 13.

An object of class \code{character} of length 4.

An object of class \code{character} of length 20.

An object of class \code{character} of length 4.

An object of class \code{character} of length 90.
}
\usage{
led_colors

uv_leds

purple_leds

ir_leds

blue_leds

green_leds

yellow_leds

orange_leds

red_leds

amber_leds

white_leds

multi_channel_leds

single_channel_leds
}
\description{
Names of members of the collection of emission spectra
\code{\link{leds.mspct}} grouped by the wavelength ranges or colors
at which they predominantly emit energy.
}
\details{
The character vectors \code{"uv_leds"}, \code{"purple_leds"},
\code{"blue_leds"}, \code{"green_leds"}, \code{"yellow_leds"},
\code{"orange_leds"} and \code{"red_leds"} contain the names of the members
of \code{leds.mspct} with peaks of emission within the wavelength range
corresponding to the light colours as defined by ISO standards. Vector
\code{amber_leds} is the union of \code{"yellow_leds"} and
\code{"orange_leds"}. Vector \code{white_leds} contains the names of spectra
for LEDs with broad or multiple peaks of emission in the visible range.
Vectors \code{"uv_leds"} and \code{"ir_leds"} contain the names for LEDs with
peak emission at wavelengths < 400 nm and wavelengths > 700 nm, respectively.
Vector \code{"multi_channel_leds"} contains names of spectra for LED arrays
that contain LED chips of more than one colour grouped into channels that can
be powered, and thus controlled, independently.

These vectors can be used to extract subsets of spectra from
\code{leds.mspct}.
}
\examples{
uv_leds
blue_leds
red_leds
white_leds
multi_channel_leds

# select LEDs emitting in the amber (yellow to orange) region
leds.mspct[amber_leds]

}
\seealso{
\code{\link{leds.mspct}}, 
\code{\link[photobiologyWavebands]{VIS_bands}},
\code{\link[photobiologyWavebands]{UV_bands}}.
}
\keyword{datasets}
