% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAG.R
\name{est_DAG}
\alias{est_DAG}
\title{Add standardized path coefficients to a DAG.}
\usage{
est_DAG(DAG, data, tree, model, method, boot = 0, ...)
}
\arguments{
\item{DAG}{A directed acyclic graph, typically created with \code{DAG}.}

\item{data}{A \code{data.frame} with data. If you have binary variables, make
sure they are either character values or factors!}

\item{tree}{A phylogenetic tree of class \code{phylo}.}

\item{model}{The evolutionary model used for the regressions on continuous
variables. See \link[phylolm:phylolm]{phylolm::phylolm} for options and details. Defaults to
Pagel's lambda model}

\item{method}{The estimation method for the binary models. See
\link[phylolm:phyloglm]{phylolm::phyloglm} for options and details. Defaults to logistic MPLE.}

\item{boot}{The number of bootstrap replicates used to estimate confidence intervals.}

\item{...}{Arguments passed on to \code{phylolm}:

\code{lower.bound}: optional lower bound for the optimization of the phylogenetic model parameter.

\code{upper.bound}: optional upper bound for the optimization of the phylogenetic model parameter.

\code{starting.value}: optional starting value for the optimization of the phylogenetic model parameter.

\code{measurement_error}: a logical value indicating whether there is measurement error sigma2_error (see Details).

Arguments passed on to \code{phyloglm}:

\code{btol}: bound on the linear predictor to bound the searching space.

\code{log.alpha.bound}: bound for the log of the parameter alpha.

\code{start.beta}: starting values for beta coefficients.

\code{start.alpha}: starting values for alpha (phylogenetic correlation).}
}
\value{
An object of class \code{fitted_DAG}.
}
\description{
Add standardized path coefficients to a DAG.
}
\examples{
  d <- DAG(LS ~ BM, NL ~ BM, DD ~ NL + LS)
  plot(d)
  d_fitted <- est_DAG(d, rhino, rhino_tree, 'lambda')
  plot(d_fitted)
}
