% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translink_samplesize.R
\name{translink_samplesize}
\alias{translink_samplesize}
\title{Calculate sample size needed to identify true transmission links}
\usage{
translink_samplesize(
  sensitivity,
  specificity,
  N,
  R = NULL,
  tdr,
  min_pairs = 1,
  assumption = "mtml"
)
}
\arguments{
\item{sensitivity}{scalar or vector giving the sensitivity of the linkage criteria}

\item{specificity}{scalar or vector giving the specificity of the linkage criteria}

\item{N}{scalar or vector giving the final outbreak size}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen}

\item{tdr}{scalar or vector giving the desired true discovery rate (1-false discovery rate)}

\item{min_pairs}{minimum number of linked pairs observed in the sample, defaults to 1 pair (2 samples); this is to ensure reasonable results are obtained}

\item{assumption}{a character vector indicating which assumptions about transmission and linkage criteria. Default = \code{'mtml'}. Accepted arguments are:
\enumerate{
\item \code{'stsl'} for the single-transmission single-linkage assumption.
\item \code{'mtsl'} for the multiple-transmission single-linkage assumption.
\item \code{'mtml'} for the multiple-transmission multiple-linkage assumption.
}}
}
\value{
scalar or vector giving the sample size needed to meet the given conditions
}
\description{
This function calculates the sample size needed to identify transmission links at
a predefined false discovery rate, given a final outbreak size \eqn{N}.
}
\examples{
translink_samplesize(sensitivity=0.99, specificity=0.995, N=100, R=1, tdr=0.75)

}
\seealso{
Other transmission linkage functions: 
\code{\link{translink_expected_links_obs_mtml}()},
\code{\link{translink_expected_links_obs_mtsl}()},
\code{\link{translink_expected_links_obs_stsl}()},
\code{\link{translink_expected_links_obs}()},
\code{\link{translink_expected_links_true_mtml}()},
\code{\link{translink_expected_links_true_mtsl}()},
\code{\link{translink_expected_links_true_stsl}()},
\code{\link{translink_expected_links_true}()},
\code{\link{translink_fdr}()},
\code{\link{translink_prob_transmit_mtml}()},
\code{\link{translink_prob_transmit_mtsl}()},
\code{\link{translink_prob_transmit_stsl}()},
\code{\link{translink_prob_transmit}()},
\code{\link{translink_tdr}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{transmission linkage functions}
