% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psem.R
\name{psem}
\alias{psem}
\title{Fitting piecewise structural equation models}
\usage{
psem(...)
}
\arguments{
\item{\dots}{A list of structural equations}
}
\value{
Returns an object of class \code{psem}
}
\description{
\code{psem} is used to unite a list of structural equations into a single
structural equation model.
}
\details{
\code{psem} takes a list of structural equations, which can be model objects
of classes: \code{lm, glm, gls, pgls, Sarlm, lme, glmmPQL, lmerMod,
lmerModLmerTest, glmerMod, glmmTMB, gam}.

It also takes objects of class \code{formula, formula.cerror}, corresponding
to additional variables to be included in the tests of directed separation
(\code{X ~ 1}) or correlated errors (\code{X1 \%~~\% X2}).

The function optionally accepts data objects of classes: \code{matrix,
data.frame, SpatialPointsDataFrame, comparative.data}, or these are derived
internally from the structural equations.
}
\examples{
mod <- psem(
lm(rich ~ cover, data = keeley),
lm(cover ~ firesev, data = keeley),
lm(firesev ~ age, data = keeley),
data = keeley
)

summary(mod)

}
\seealso{
\code{\link{summary.psem}}, \code{\link{\%~~\%}}
}
\author{
Jon Lefcheck <jslefche@gmail.com>
}
