% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{bracket}
\alias{bracket}
\alias{double_bracket}
\alias{assign_bracket}
\alias{assign_double_bracket}
\alias{dollar}
\alias{at_sign}
\alias{add}
\alias{subtract}
\alias{multiply}
\alias{divide}
\alias{integer_divide}
\alias{mod}
\alias{raise_to_power}
\alias{matrix_multiply}
\alias{and}
\alias{or}
\alias{not}
\alias{single_and}
\alias{single_or}
\alias{equals}
\alias{greater_than}
\alias{greater_or_equal}
\alias{less_than}
\alias{less_or_equal}
\alias{is_in}
\alias{assign_names}
\alias{assign_colnames}
\alias{assign_rownames}
\alias{assign_dimnames}
\alias{assign_class}
\alias{assign_attributes}
\alias{assign_attr}
\alias{assign_levels}
\alias{assign_contrasts}
\alias{assign_units}
\alias{assign_comment}
\alias{assign_diag}
\alias{assign_dim}
\alias{assign_length}
\alias{assign_as_na}
\title{Pipe-able aliases}
\description{
pipebind provides several aliases for unary/binary operators (e.g., \code{+})
and replacement functions (e.g., \verb{names<-()}) that facilitate using these
functions in a \verb{|>} chain.

Some unary/binary operators cannot currently be used with the \verb{|>} pipe,
such as \code{+}, \code{-}, or \code{\%*\%}. These aliases provide a way to use these functions
with the \verb{|>} pipe.

Currently implemented aliases are
\tabular{ll}{
\strong{Extract and replace elements} \tab    \code{ }              \cr
\code{bracket}                   \tab    \code{`[`}            \cr
\code{double_bracket}            \tab    \code{`[[`}           \cr
\code{assign_bracket}            \tab    \code{`[<-`}          \cr
\code{assign_double_bracket}     \tab    \code{`[<-`}          \cr
\code{dollar}                    \tab    \code{`$`}            \cr
\code{at_sign}                   \tab    \code{`@`}            \cr
\strong{Arithmetic operators}         \tab    \code{ }              \cr
\code{add}                       \tab    \code{`+`}            \cr
\code{subtract}                  \tab    \code{`-`}            \cr
\code{multiply}                  \tab    \code{`*`}            \cr
\code{divide}                    \tab    \code{`/`}            \cr
\code{integer_divide}            \tab    \code{`\%/\%`}        \cr
\code{mod}                       \tab    \code{`\%\%`}         \cr
\code{raise_to_power}            \tab    \code{`^`}            \cr
\code{matrix_multiply}           \tab    \code{`\%*\%`}        \cr
\strong{Logical comparisons}          \tab    \code{ }              \cr
\code{and}                       \tab    \code{`&`}            \cr
\code{or}                        \tab    \code{`|`}            \cr
\code{not}                       \tab    \code{`!`}            \cr
\code{single_and}                \tab    \code{`&&`}           \cr
\code{single_or}                 \tab    \code{`||`}           \cr
\code{equals}                    \tab    \code{`==`}           \cr
\code{greater_than}              \tab    \code{`>`}            \cr
\code{greater_or_equal}          \tab    \code{`>=`}           \cr
\code{less_than}                 \tab    \code{`<`}            \cr
\code{less_or_equal}             \tab    \code{`<=`}           \cr
\code{is_in}                     \tab    \code{`\%in\%`}       \cr
\strong{Assign attributes}            \tab    \code{ }              \cr
\code{assign_names}              \tab    \code{`names<-`}      \cr
\code{assign_colnames}           \tab    \code{`colnames<-`}   \cr
\code{assign_rownames}           \tab    \code{`rownames<-`}   \cr
\code{assign_dimnames}           \tab    \code{`dimnames<-`}   \cr
\code{assign_class}              \tab    \code{`class<-`}      \cr
\code{assign_attributes}         \tab    \code{`attributes<-`} \cr
\code{assign_attr}               \tab    \code{`attr<-`}       \cr
\code{assign_levels}             \tab    \code{`levels<-`}     \cr
\code{assign_contrasts}          \tab    \code{`contrasts<-`}  \cr
\code{assign_units}              \tab    \code{`units<-`}      \cr
\code{assign_comment}            \tab    \code{`comment<-`}    \cr
\code{assign_diag}               \tab    \code{`diag<-`}       \cr
\code{assign_dim}                \tab    \code{`dim<-`}        \cr
\code{assign_length}             \tab    \code{`length<-`}     \cr
\code{assign_as_na}              \tab    \code{`is.na<-`}      \cr
}
}
\note{
Inspired and some alias names adapted from from \emph{magrittr}.
Reused code Copyright (c) 2023 magrittr authors.
}
\examples{
 mtcars |>
   bracket(, 1:4)

 1:10 |>
   add(5) |>
   matrix(dimnames = list(letters[1:10], "x")) |>
   matrix_multiply(seq(10, 100, by = 10))

data.frame(1:10, letters[1:10]) |>
  assign_names(c("numbers", "letters"))
}
