% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_pipe.R
\name{time_pipe}
\alias{time_pipe}
\title{Measure execution time in a pipeline}
\usage{
time_pipe(
  .data,
  label = NULL,
  log = getOption("pipetime.log", NULL),
  console = getOption("pipetime.console", TRUE),
  unit = getOption("pipetime.unit", "secs")
)
}
\arguments{
\item{.data}{Input object passed through the pipeline.}

\item{label}{Character string. Operation name. Defaults to the expression if \code{NULL}.}

\item{log}{Character string or \code{NULL}. Name of a log data frame in \code{.pipetime_env}. Default: \code{NULL}.}

\item{console}{Logical. Print timing to console? Default: \code{TRUE}.}

\item{unit}{Character string. Time unit for \code{\link[base:difftime]{base::difftime()}}. One of \code{"secs"}, \code{"mins"}, \code{"hours"}, \code{"days"}, \code{"weeks"}. Default: \code{"secs"}.}
}
\value{
\code{.data}, unchanged. Timing information is printed and/or stored separately.
}
\description{
Records the runtime of a pipeline (\verb{|>}) from its start to the point where \code{time_pipe()} is called.
Prints results to the console and/or logs them in \code{.pipetime_env}.
Defaults can be set via \verb{options(pipetime.*)}.
}
\details{
\code{time_pipe()} measures elapsed time from pipeline start to the call.
If \code{log} is set, results are appended to a data frame in \code{.pipetime_env} with columns:
\itemize{
\item \code{timestamp}: Pipeline start time (\code{POSIXct})
\item \code{label}: Operation label
\item \code{duration}: Elapsed time since pipeline start (\code{numeric})
\item \code{unit}: Time unit used
}

Stored logs can be retrieved with \code{\link[=get_log]{get_log()}}.
}
\examples{
library(dplyr)
data.frame(x = 1:3) |>
mutate(y = {Sys.sleep(0.5); x*2 }) |>
time_pipe("calc 1") |>
mutate(z = {Sys.sleep(0.5); x/2 }) |>
time_pipe("total pipeline")

}
