% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pix_query}
\alias{pix_query}
\title{Get Raw Data from PIX API}
\usage{
pix_query(
  endpoint,
  params = NULL,
  filter = NULL,
  select = NULL,
  orderby = NULL,
  top = NULL,
  skip = NULL,
  format = "json",
  verbose = TRUE
)
}
\arguments{
\item{endpoint}{Character string specifying the endpoint name.}

\item{params}{Named list of endpoint parameters. Each endpoint requires
different parameters:
\itemize{
\item ChavesPix: \code{list(Data = "YYYY-MM-DD")}
\item TransacoesPixPorMunicipio: \code{list(DataBase = "YYYYMM")}
\item EstatisticasTransacoesPix: \code{list(Database = "YYYYMM")}
\item EstatisticasFraudesPix: \code{list(Database = "YYYYMM")}
}}

\item{filter}{OData filter expression as a character string.}

\item{select}{Character vector of columns to select.}

\item{orderby}{OData orderby expression as a character string.}

\item{top}{Integer; maximum number of records to return.}

\item{skip}{Integer; number of records to skip.}

\item{format}{Response format: "json" (default), "xml", "csv", or "html".}

\item{verbose}{Logical; if TRUE, prints progress messages.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with the raw API response data.
}
\description{
Low-level function to fetch data from any PIX API endpoint with custom
parameters.
}
\examples{
\dontrun{# It usually takes much longer than 5 seconds.
# Custom query for keys
pix_query(
  endpoint = "ChavesPix",
  params = list(Data = "2025-12-01"),
  top = 10
)

# Custom query for transaction stats
pix_query(
  endpoint = "EstatisticasTransacoesPix",
  params = list(Database = "202509"),
  top = 10
)
}
}
