% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pchit_grid.R
\name{pchit_grid}
\alias{pchit_grid}
\title{Plots multiple heatmaps identifying hits from the first principal component}
\usage{
pchit_grid(data, well, plate_id, ...)
}
\arguments{
\item{data}{Numerical values, either a dataframe or a matrix}

\item{well}{Vector of well identifers e.g "A01"}

\item{plate_id}{Vector of plate identifiers e.g "Plate_1"}

\item{...}{additional arguments to `platetools::hit_grid()`}
}
\value{
ggplot plot
}
\description{
Converts numerical values, well labels, and plate labels into multiple heatmaps
of plates, with z-scored principal components coloured dependent on a specified
threshold of standard deviations above or below the average.
}
\examples{
df01 <- data.frame(
  well = num_to_well(1:96),
  plate = 1,
  vals1 = rnorm(1:96),
  vals2 = rnorm(1:96))

df02 <- data.frame(
  well = num_to_well(1:96),
  plate = 2,
  vals1 = rnorm(1:96),
  vals2 = rnorm(1:96))

df <- rbind(df01, df02)

pchit_grid(data = df[,3:4],
           well = df$well,
           plate_id = df$plate,
           plate = 96)
}
