% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_pick.R
\name{utils_pick}
\alias{utils_pick}
\alias{pick_count}
\alias{pick_coords}
\alias{pick_rgb}
\alias{pick_palette}
\title{Utilities for picking up points in an image}
\usage{
pick_count(
  img,
  n = Inf,
  col = "red",
  viewer = get_pliman_viewer(),
  external_device = FALSE,
  size = 0.8,
  plot = TRUE,
  verbose = TRUE
)

pick_coords(
  img,
  n = Inf,
  col = "red",
  viewer = get_pliman_viewer(),
  external_device = FALSE,
  size = 0.8,
  verbose = TRUE
)

pick_rgb(
  img,
  n = Inf,
  col = "red",
  viewer = get_pliman_viewer(),
  external_device = FALSE,
  size = 0.8,
  plot = TRUE,
  verbose = TRUE
)

pick_palette(
  img,
  n = Inf,
  r = 2,
  shape = "box",
  viewer = get_pliman_viewer(),
  external_device = FALSE,
  show = "rgb",
  title = "Pick colors in the image",
  index = "B",
  random = TRUE,
  width = 100,
  height = 100,
  col = "red",
  size = 0.8,
  plot = TRUE,
  palette = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{n}{The number of points of the \verb{pick_*} function. Defaults to \code{Inf}.
This means that picking will run until the user press Esc.}

\item{col, size}{The color and size for the marker point.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{external_device}{Logical. If \code{TRUE} (default), opens an external
graphics window when running inside RStudio to ensure accurate point
selection using \code{\link[=locator]{locator()}}. Ignored when not in RStudio or when using
\code{viewer = "mapview"}.}

\item{plot}{Call a new \code{plot(img)} before processing? Defaults to \code{TRUE}.}

\item{verbose}{If \code{TRUE} (default) shows a counter in the console.}

\item{r}{The radius of neighborhood pixels. Defaults to \code{1}.}

\item{shape}{A character vector indicating the shape of the brush around the
selected pixel. It  can be \code{"box"}, \code{"disc"}, \code{"diamond"}, \code{"Gaussian"} or
\code{"line"}. Defaults to \code{"box"}. In this case, if \code{'r = 1'}, all the 8
surrounding pixels are sampled. Setting to \code{"disc"} and increasing the
radius (\code{r}) will select surrounding pixels towards the format of a sphere
around the selected pixel.}

\item{show}{How to plot in mapview viewer, either \verb{'rgb} or \code{'index'}.}

\item{title}{The title of the map view when \code{viewer}is used.}

\item{index}{The index to use for the index view. Defaults to 'B'.}

\item{random}{Randomize the selected pixels? Defaults to \code{TRUE}.}

\item{width, height}{The width and height of the generated palette. Defaults
to \code{100} for both, i.e., a square image of 100 x 100.}

\item{palette}{Plot the generated palette? Defaults to \code{TRUE}.}
}
\value{
\itemize{
\item \code{pick_count()} returns \code{data.frame} with the \code{x} and \code{y} coordinates of the
selected point(x).
\item \code{pick_rgb()} returns a \code{data.frame} with the R, G, and B values of the
selected point(s).
\item \code{pick_palette()} returns an object of class \code{Image}.
}
}
\description{
\itemize{
\item \code{pick_count()} opens an interactive section where the user will be able to
click in the image to count objects (points) manually. In each mouse click, a
point is drawn and an upward counter is shown in the console. After \code{n}
counts or after the user press Esc, the interactive process is terminated and
the number of counts is returned.
\item \code{pick_coord()} Picks coordinates from the image
\item \code{pick_palette()}  creates an image palette by picking up color point(s)
from the image.
\item \code{pick_rgb()} Picks up the RGB values from selected point(s) in the image.
}
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
img <- image_pliman("soybean_touch.jpg")

# start a counting process
pick_count(img)

# get rgb from point(s)
pick_rgb(img)

# create a palette from point(s)
pick_palette(img)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
