% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel.R
\name{readIBS}
\alias{readIBS}
\title{Read PLINK Binary IBS matrix}
\usage{
readIBS(pfx, fid = ".")
}
\arguments{
\item{pfx}{prefix of the IBS file set.}

\item{fid}{seperate after family ID (def=NULL, use IID only)}
}
\value{
IBS matrix with row and column names set to sample ID.
}
\description{
A PLINK IBS (Identity by State) matrix is represented by
\describe{
\item{.mibs.bin:}{IBS matrix in binary}
\item{.mibs.id :}{FID and IID in text}
}
A binary IBS matrix is the result of PLINK \code{--distance ibs bin}
}
\examples{
pfx <- file.path(system.file("extdata", package="plinkFile"), "m20")
(readIBS(pfx))

}
