% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plu_more.R
\name{plu_more}
\alias{plu_more}
\alias{more}
\title{Informatively display a maximum number of elements}
\usage{
plu_more(x, max = 5, type = TRUE, fn = NULL, ..., det = "more")

more(x, max = 5, type = TRUE, fn = NULL, ..., det = "more")
}
\arguments{
\item{x}{A vector or list.}

\item{max}{The maximum number of items to list.
Additional arguments are replaced with "{n} more".
Defaults to \code{5}.
If \code{max} if \code{\link{Inf}}, \code{\link{NULL}}, \code{\link{FALSE}}, or \code{\link{NA}}, all elements are
preserved.}

\item{type}{A \link{logical} or \link{character}.
\itemize{
\item If a character, \code{type} is passed to \code{\link[=ral]{ral()}} and pasted after the
number of elements.
\item If \code{\link{TRUE}}, the default, the first \link{class} of \code{x} is used as the type.
\itemize{
\item If \code{x} is a \link{list} with different classes of element, "element" is used
in place of a class name.
}
\item If \code{\link{FALSE}} or \code{\link{NA}}, nothing is pasted after the number of elements.
}}

\item{fn}{A function to apply to the number of additional elements.
Default to \code{\link{NULL}}, which applies no function.}

\item{...}{Additional arguments to \code{fn}.}

\item{det}{A determiner to place before the number of additional elements.
Defaults to "more".}
}
\value{
If \code{x} is a vector, a character vector with a length of \code{max} + 1
or less.
If \code{x} is a list, a list with \code{max + 1} or fewer elements.
}
\description{
Informatively display a maximum number of elements
}
\examples{
plu::more(letters)

# Setting `max`
plu::more(letters, max = 10)
plu::more(letters, max = 27)

# If `max` is Inf or NULL, all elements will be preserved
plu::more(letters, max = Inf)

# If `max` is less than one, no elements will be preserved
plu::more(letters, max = 0)

# Setting element type
plu::more(letters, type = "letter")

# If `type` is FALSE or NULL, no type will be included
plu::more(letters, type = FALSE)

# Automatically generating type
plu::more(1:100)
plu::more(as.list(1:100))
plu::more(c(as.list(1:2), as.list(letters)))
plu::more(fracture::fracture((1:9) / (9:1)))

# Setting a determiner other than "more"
plu::more(letters, det = "other")

# Applying a function to the number
plu::more(letters, fn = nombre::cardinal)

# Automatic pluralization of type
fish <- c("sea bass", "crucian carp", "dace", "coelecanth")
plu::more(fish, max = 3, type = "fish")
plu::more(fish, max = 2, type = "fish")

teeth <- c("incisor", "canine", "molar", "wisdom tooth")
plu::more(teeth, max = 3, type = "tooth")
plu::more(teeth, max = 2, type = "tooth")

cacti <- c("saguaro", "prickly pear", "barrel", "star")
plu::more(cacti, max = 3, type = "cactus")
plu::more(cacti, max = 2, type = "cactus")

# Using plu_more() within a function
verbose_sqrt <- function(x) {
  if (any(x < 0)) {
    problems <- x[x < 0]
    prob_msg <- crayon::silver(encodeString(problems, quote = "`"))

    warning(
      "Square root is undefined for ",
      and::and(plu::more(prob_msg, fn = crayon::silver, type = "input.")),
      call. = FALSE
    )
  }

  sqrt(x)
}

ints <- round(runif(20, -10, 10))
verbose_sqrt(ints)
}
