% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_handlers.R
\name{api_request_header_handlers}
\alias{api_request_header_handlers}
\alias{api_get_header}
\alias{api_head_header}
\alias{api_post_header}
\alias{api_put_header}
\alias{api_delete_header}
\alias{api_connect_header}
\alias{api_options_header}
\alias{api_trace_header}
\alias{api_patch_header}
\alias{api_any_header}
\title{Add a handler for a request header}
\usage{
api_get_header(
  api,
  path,
  handler,
  serializers = get_serializers(),
  parsers = get_parsers(),
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  route = NULL
)

api_head_header(
  api,
  path,
  handler,
  serializers = get_serializers(),
  parsers = get_parsers(),
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  route = NULL
)

api_post_header(
  api,
  path,
  handler,
  serializers = get_serializers(),
  parsers = get_parsers(),
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  route = NULL
)

api_put_header(
  api,
  path,
  handler,
  serializers = get_serializers(),
  parsers = get_parsers(),
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  route = NULL
)

api_delete_header(
  api,
  path,
  handler,
  serializers = get_serializers(),
  parsers = get_parsers(),
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  route = NULL
)

api_connect_header(
  api,
  path,
  handler,
  serializers = get_serializers(),
  parsers = get_parsers(),
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  route = NULL
)

api_options_header(
  api,
  path,
  handler,
  serializers = get_serializers(),
  parsers = get_parsers(),
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  route = NULL
)

api_trace_header(
  api,
  path,
  handler,
  serializers = get_serializers(),
  parsers = get_parsers(),
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  route = NULL
)

api_patch_header(
  api,
  path,
  handler,
  serializers = get_serializers(),
  parsers = get_parsers(),
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  route = NULL
)

api_any_header(
  api,
  path,
  handler,
  serializers = get_serializers(),
  parsers = get_parsers(),
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  route = NULL
)
}
\arguments{
\item{api}{A plumber2 api object to add the handler to}

\item{path}{A string giving the path the handler responds to. See Details}

\item{handler}{A handler function to call when a request is matched to the
path}

\item{serializers}{A named list of serializers that can be used to format the
response before sending it back to the client. Which one is selected is based
on the request \code{Accept} header. See \code{\link[=get_serializers]{get_serializers()}} for a helper to
construct this}

\item{parsers}{A named list of parsers that can be used to parse the
request body before passing it in as the \code{body} argument. Which one is
selected is based on the request \code{Content-Type} header. See \code{\link[=get_parsers]{get_parsers()}}
for a helper to construct this}

\item{use_strict_serializer}{By default, if a serializer that respects the
requests \code{Accept} header cannot be found, then the first of the provided ones
are used. Setting this to \code{TRUE} will instead send back a
\verb{406 Not Acceptable} response}

\item{download}{Should the response mark itself for download instead of being
shown inline? Setting this to \code{TRUE} will set the \code{Content-Disposition}
header in the response to \code{attachment}. Setting it to a string is equivalent
to setting it to \code{TRUE} but will in addition also set the default filename of
the download to the string value}

\item{async}{If \code{FALSE} create a regular handler. If \code{TRUE}, use the default
async evaluator to create an async handler. If a string, the async evaluator
registered to that name is used. If a function is provided then this is used
as the async evaluator. See the \emph{Async} section for more detail}

\item{then}{A list of function to be called once the async handler is done.
The functions will be chained using \code{\link[promises:then]{promises::then()}}. See the \emph{Async}
section for more detail}

\item{route}{The route this handler should be added to. Defaults to the last
route in the stack. If the route does not exist it will be created as the
last route in the stack}
}
\value{
These functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
These handlers are called before the request body has been received and lets
you preemptively reject requests before receiving their full content. If the
handler does not return \link{Next} then the request will be returned at once.
Most of your logic, however, will be in the main handlers and you are asked to
consult the \link{api_request_handlers} docs for in-depth details on how to use
request handlers in general.
}
\section{Using annotation}{
Adding request header handler is done in the same way as for \link[=api_request_handlers]{standard request handlers}. The only difference is that you
include a \verb{@header} tag as well. It is not normal to document header requests
as they usually exist as internal controls. You can add \verb{@noDoc} to avoid
generating OpenAPI docs for the handler

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* A header handler authorizing users
#*
#* @get /*
#*
#* @header
#* @noDoc
function(client_id, response) \{
  if (user_is_allowed(username)) \{
    Next
  \} else \{
    response$status <- 404L
    Break
  \}
\}
}\if{html}{\out{</div>}}
}

\examples{
# Simple size limit (better to use build-in functionality)
api() |>
  api_post_header(
    "/*",
    function(request, response) {
      if (request$get_header("content-type") > 1024) {
        response$status <- 413L
        Break
      } else {
        Next
      }
    }
  )


}
\seealso{
Other Request Handlers: 
\code{\link{api_request_handlers}}
}
\concept{Request Handlers}
