% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{dealWithDf}
\alias{dealWithDf}
\title{Deal with data frame}
\usage{
dealWithDf(x, codeLength)
}
\arguments{
\item{x}{An object of class (sf, data.frame).}

\item{codeLength}{A number.}
}
\value{
A character vector of length nrow(x).
}
\description{
Adapt the genPluscode function to a class object (sf, data.frame), it returns a vector
containing the pluscode of the coordinates in the records of the input data frame.
}
\examples{
library(sf)
coordinates <- data.frame(lon = -6.56718, lat = 52.50145)
geom_df <- st_as_sf(coordinates, coords = c("lon", "lat"), crs = 4326)
dealWithDf(geom_df, 12)
###
coordinates_df <- data.frame(lon = c(-6.56718, -6), lat = c(52.50145, 52))
geom_df <- st_as_sf(coordinates_df, coords = c("lon", "lat"), crs = 4326)
dealWithDf(geom_df, 12)
}
