% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_rhs_data_funs.R
\name{ind_rhs_plot_mlx}
\alias{ind_rhs_plot_mlx}
\title{Generate individual Right-hand side data plot (Monolix)}
\usage{
ind_rhs_plot_mlx(
  rhs,
  x_var,
  inputs,
  group,
  est_parms = NULL,
  mlx_file = NULL,
  time_nn = NULL,
  act = NULL,
  beta = 20
)
}
\arguments{
\item{rhs}{(string) String of right-hand side}

\item{x_var}{(string) Name of the variable in inputs against which the right-hand data should be plotted.}

\item{inputs}{(dataframe) Dataframe of inputs, with corresponding columns (including matching column names 
for each variable in \emph{rhs}.}

\item{group}{(string) Name of column in \emph{inputs} dataframe defining groups/individuals.}

\item{est_parms}{(dataframe; semi-optional) A data frame with estimated individual parameters from the NN 
extracted through the \emph{indparm_extractor_mlx} function. For optionality, see \strong{Details}.}

\item{mlx_file}{(string; semi-optional) (path)/name of the Monolix run. Must include ".mlxtran" and estimation bust have been run previously. For optionality, see \strong{Details}.}

\item{time_nn}{(boolean vector) Vector for each NN in \emph{rhs} defining whether the neural network is a time-dependent neural network or not. Default value for all NN is FALSE.}

\item{act}{(character vector) Vector for each NN in \emph{rhs} defining the activation function used in the NN. Default value for all NN is "ReLU".}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if any \emph{act} is softplus; Default to 20.}
}
\value{
ggplot of right-hand side plot for all individuals
}
\description{
This functions allows to generate a right-hand side plot with multiple subjects, i.e., combined derivative data of multiple NNs and base-R operations.
}
\details{
Either \emph{est_parms} or \emph{mlx_file} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\examples{
# Generate individual rhs-plot for predicted observations

mlx_path <- system.file("extdata","mlx_example1_ind.mlxtran",package="pmxNODE")
data_path <- system.file("extdata","mlx_example1_ind","predictions.txt",package="pmxNODE")

est_parms <- indparm_extractor_mlx(mlx_path)

input_data <- read.table(data_path,sep=",",header=TRUE)[,c("id","indivPred_mode","time")]
colnames(input_data) <- c("id","NNc","NNct")
                  
rhs_plot <- ind_rhs_plot_mlx(rhs="NNc + NNct",
                             x_var = "NNc",
                             group = "id",
                             inputs = input_data,
                             est_parms = est_parms,
                             time_nn = c(FALSE, TRUE))
}
\author{
Dominic Bräm
}
