% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_rhs_data_funs.R
\name{ind_rhs_plot_nm}
\alias{ind_rhs_plot_nm}
\title{Generate individual Right-hand side data plot (NONMEM)}
\usage{
ind_rhs_plot_nm(
  rhs,
  x_var,
  inputs,
  group,
  est_parms = NULL,
  nm_res_file = NULL,
  nm_phi_file = NULL,
  time_nn = NULL,
  act = NULL,
  beta = 20
)
}
\arguments{
\item{rhs}{(string) String of right-hand side}

\item{x_var}{(string) Name of the variable in inputs against which the right-hand data should be plotted.}

\item{inputs}{(dataframe) Dataframe of inputs, with corresponding columns (including matching column names 
for each variable in \emph{rhs}.}

\item{group}{(string) Name of column in \emph{inputs} dataframe defining groups/individuals.}

\item{est_parms}{(dataframe; semi-optional) A data frame with estimated individual parameters from the NN 
extracted through the \emph{indparm_extractor_nm} function. For optionality, see \strong{Details}.}

\item{nm_res_file}{(string; semi-optional) (path)/name of the results file of a NONMEM run, must include file extension, e.g., “.res”. For optionality, see \strong{Details}.}

\item{nm_phi_file}{(string; semi-optional) (path)/name of the phi file of a NONMEM run, must include file extension “.phi”. For optionality, see \strong{Details}.}

\item{time_nn}{(boolean vector) Vector for each NN in \emph{rhs} defining whether the neural network is a time-dependent neural network or not. Default value for all NN is FALSE.}

\item{act}{(character vector) Vector for each NN in \emph{rhs} defining the activation function used in the NN. Default value for all NN is "ReLU".}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if any \emph{act} is softplus; Default to 20.}
}
\value{
ggplot of right-hand side plot for all individuals
}
\description{
This functions allows to generate a right-hand side plot with multiple subjects, i.e., combined derivative data of multiple NNs and base-R operations.
}
\details{
Either \emph{est_parms} or \emph{mlx_file} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\examples{
# Generate individual rhs-plot for predicted observations

res_path <- system.file("extdata","nm_example1_model_converted_ind.res",package="pmxNODE")
phi_path <- system.file("extdata","nm_example1_model_converted_ind.phi",package="pmxNODE")
data_path <- system.file("extdata","nm_example1.tab",package="pmxNODE")

est_parms <- indparm_extractor_nm(res_path,phi_path)

input_data <- read.table(data_path,skip=1,header=TRUE)[,c("ID","IPRED","TIME")]
colnames(input_data) <- c("ID","NNc","NNt")
                  
rhs_plot <- ind_rhs_plot_nm(rhs="NNc + NNt",
                             x_var = "NNc",
                             inputs = input_data,
                             group = "ID",
                             est_parms=est_parms,
                             time_nn = c(FALSE, TRUE))
}
\author{
Dominic Bräm
}
