% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_read_agent.R
\name{yaml_read_agent}
\alias{yaml_read_agent}
\title{Read a \strong{pointblank} YAML file to create an \emph{agent} object}
\usage{
yaml_read_agent(filename, path = NULL)
}
\arguments{
\item{filename}{\emph{File name}

\verb{scalar<character>} // \strong{required}

The name of the YAML file that contains fields related to an \emph{agent}.}

\item{path}{\emph{File path}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional path to the YAML file (combined with \code{filename}).}
}
\value{
A \code{ptblank_agent} object.
}
\description{
With \code{yaml_read_agent()} we can read a \strong{pointblank} YAML file that
describes a validation plan to be carried out by an \emph{agent} (typically
generated by the \code{\link[=yaml_write]{yaml_write()}} function. What's returned is a new \emph{agent}
with that validation plan, ready to interrogate the target table at will
(using the table-prep formula that is set with the \code{tbl} argument of
\code{\link[=create_agent]{create_agent()}}). The agent can be given more validation steps if needed
before using \code{\link[=interrogate]{interrogate()}} or taking part in any other agent ops (e.g.,
writing to disk with outputs intact via \code{\link[=x_write_disk]{x_write_disk()}} or again to
\strong{pointblank} YAML with \code{\link[=yaml_write]{yaml_write()}}).

To get a picture of how \code{yaml_read_agent()} is interpreting the validation
plan specified in the \strong{pointblank} YAML, we can use the
\code{\link[=yaml_agent_show_exprs]{yaml_agent_show_exprs()}} function. That function shows us (in the console)
the \strong{pointblank} expressions for generating the described validation plan.
}
\section{Examples}{


There's a YAML file available in the \strong{pointblank} package that's also
called \code{"agent-small_table.yml"}. The path for it can be accessed through
\code{system.file()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yml_file_path <-
  system.file(
    "yaml", "agent-small_table.yml",
    package = "pointblank"
  )
}\if{html}{\out{</div>}}

The YAML file can be read as an agent with a pre-existing validation plan by
using the \code{yaml_read_agent()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <- yaml_read_agent(filename = yml_file_path)

agent
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_yaml_write_1.png" alt="This image was generated from the first code example in the `yaml_write()` help file." style="width:100\%;">
}
}

This particular agent is using \code{~ tbl_source("small_table", "tbl_store.yml")}
to source the table-prep from a YAML file that holds a table store (can be
seen using \code{yaml_agent_string(agent = agent)}). Let's put that file in the
working directory (the \strong{pointblank} package has the corresponding YAML
file):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yml_tbl_store_path <-
  system.file(
    "yaml", "tbl_store.yml",
    package = "pointblank"
  )

file.copy(from = yml_tbl_store_path, to = ".")
}\if{html}{\out{</div>}}

As can be seen from the validation report, no interrogation was yet
performed. Saving an agent to YAML will remove any traces of interrogation
data and serve as a plan for a new interrogation on the same target table. We
can either follow this up with with \code{\link[=interrogate]{interrogate()}} and get an agent with
intel, or, we can interrogate directly from the YAML file with
\code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <- yaml_agent_interrogate(filename = yml_file_path)

agent
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_yaml_write_2.png" alt="This image was generated from the second code example in the `yaml_write()` help file." style="width:100\%;">
}
}
}

\section{Function ID}{

11-2
}

\seealso{
Other pointblank YAML: 
\code{\link{yaml_agent_interrogate}()},
\code{\link{yaml_agent_show_exprs}()},
\code{\link{yaml_agent_string}()},
\code{\link{yaml_exec}()},
\code{\link{yaml_informant_incorporate}()},
\code{\link{yaml_read_informant}()},
\code{\link{yaml_write}()}
}
\concept{pointblank YAML}
