% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/politenessDNM.R
\name{politenessDNM}
\alias{politenessDNM}
\title{Politeness Features}
\usage{
politenessDNM(text, uk_english = FALSE)
}
\arguments{
\item{text}{character A vector of texts, each of which will be tallied for politeness features.}

\item{uk_english}{logical Does the text contain any British English spelling? Including variants (e.g. Canadian). Default is FALSE}
}
\value{
a data.frame of politeness features, with one row for every item in `text`. The original names are used where possible.
}
\description{
Detects linguistic markers of politeness in natural language.
    This function emulates the original features of the Danescu-Niculescu-Mizil Politeness paper. This primarily exists to contrast with the full feature set in the main package, and is not recommended otherwise.
}
\examples{

\dontrun{
# Connect to SpaCy installation for part-of-speech features
install.packages("spacyr")
spacyr::spacy_initialize(python_executable = PYTHON_PATH)
data("phone_offers")

politeness(phone_offers$message)

}


}
\references{
Danescu-Niculescu-Mizil, C., Sudhof, M., Jurafsky, D., Leskovec, J., & Potts, C. (2013). A computational approach to politeness with application to social factors. arXiv preprint arXiv:1306.6078.
}
