% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_diag.R
\name{diag}
\alias{diag}
\alias{diag,polynomial-method}
\alias{diag,polyMatrix-method}
\title{Polynomial matrix Diagonals
Extract or construct a diagonal polynomial matrix.}
\usage{
diag(x = 1, nrow, ncol, names = TRUE)

\S4method{diag}{polynomial}(x, nrow, ncol)

\S4method{diag}{polyMatrix}(x)
}
\arguments{
\item{x}{a polynomial matrix, or a polynomial, or an \R object}

\item{nrow, ncol}{optional dimensions for the result when x is not a matrix}

\item{names}{not used for polynomial matrices}
}
\description{
Polynomial matrix Diagonals
Extract or construct a diagonal polynomial matrix.
}
\details{
In case of polynomial objects, \code{diag} has 2 distinct usage:
\itemize{
\item \code{x} is a polynomial, returns a polynomial matrix the given diagonal
and zero off-diagonal entries.
\item \code{x} is a polynomial matrix, returns a vector as a polynomial matrix of
diagonal elements
}

For polynomial, either \code{nrow} or \code{ncol} must be provided.
}
\section{Methods (by class)}{
\itemize{
\item \code{polynomial}: for a polynomial, returns a polynomial matrix with the given diagonal

\item \code{polyMatrix}: for a polynomial matrix extracts diagonal

For polynomial matrix, neither \code{nrow} nor \code{ncol} cannot be provided.
}}

\examples{

# numericals and numerical matrices
diag(matrix(1:12, 3, 4)) ## 1 5 8
diag(9, 2, 2)
##      [,1] [,2]
## [1,]    9    0
## [2,]    0    9



# polynomial
diag(parse.polynomial("1+x+3x^2"), 2, 3)
##                [,1]           [,2]   [,3]
## [1,]   1 + x + 3x^2              0      0
## [2,]              0   1 + x + 3x^2      0


# polynomial matrix
diag(parse.polyMatrix(
  "-3 + x^2, 2 + 4 x,  -x^2",
  "       1,       2, 3 + x",
  "      2x,       0, 2 - 3x"
))
##            [,1]   [,2]     [,3]
## [1,]   -3 + x^2      2   2 - 3x

}
\seealso{
Base \code{\link[base:diag]{base::diag()}} for numericals and numerical matrices
}
